package com.jurismarches.vradi.services.managers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * DateParser.
 *
 * @author schorlet
 * @version $Revision: 811 $ $Date: 2010-04-29 14:07:44 +0200 (jeu., 29 avril 2010) $
 * @since 10 mars 2010 12:02:21
 * 
 * @deprecated unused replaced by {@link DateParser2}.
 */
@Deprecated
public class DateParser {
    private DateParser() {}
    
    private static final TimeZone timezone = TimeZone.getTimeZone("GMT");
    
    private static final String ND1 = "N.D.";
    private static final String ND2 = "---";
    
    /*
     * Liste des formats supportés (par ordre de frequence)
     */
    private static final ArrayList<SimpleDateFormat> formats = new ArrayList<SimpleDateFormat>();
    
    static {
        // formats frequemments rencontrés
        {
            // 10 avril 2010, à 12 heures
            formats.add(new SimpleDateFormat("dd MMMM yyyy', à' HH 'heures'"));
            // 5 mai 2010, à 12:00.
            formats.add(new SimpleDateFormat("dd MMMM yyyy', à' HH:mm'.'"));
            // 2 avril 2010, à 15 h 30
            formats.add(new SimpleDateFormat("dd MMMM yyyy', à' HH 'h' mm"));
            // 2010-04-02 12:00:00
            formats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        
        // autres formats et variantes
        {
            // 23 mars 2010
            formats.add(new SimpleDateFormat("dd MMMM yyyy"));
            // 23 mars 2010.
            formats.add(new SimpleDateFormat("dd MMMM yyyy'.'"));
            
            // 10/03/2010 à 12:00
            formats.add(new SimpleDateFormat("dd/MM/yyyy 'à' HH:mm"));
            // 10/03/2010 à 12:00.
            formats.add(new SimpleDateFormat("dd/MM/yyyy 'à' HH:mm'.'"));
            // 10/03/2010 à 12 heures
            formats.add(new SimpleDateFormat("dd/MM/yyyy 'à' HH 'heures'"));
            // 10/03/2010
            formats.add(new SimpleDateFormat("dd/MM/yyyy"));
            
            // 2010-04-02 12:00:00
            formats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            // 2010-04-02 12:00
            formats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm"));
            // 2008-12-21
            formats.add(new SimpleDateFormat("yyyy-MM-dd"));
            
            // 10 avril 2010 à 12 heures
            formats.add(new SimpleDateFormat("dd MMMM yyyy 'à' HH 'heures'"));
            
            // 5 mai 2010 à 12:00
            formats.add(new SimpleDateFormat("dd MMMM yyyy 'à' HH:mm"));
            // 5 mai 2010 à 12:00.
            formats.add(new SimpleDateFormat("dd MMMM yyyy 'à' HH:mm'.'"));
            // 5 mai 2010, à 12:00
            formats.add(new SimpleDateFormat("dd MMMM yyyy', à' HH:mm"));
            
            // 2 avril 2010 à 15 h 30
            formats.add(new SimpleDateFormat("dd MMMM yyyy 'à' HH 'h' mm"));
            // 2 avril 2010 à 15h30
            formats.add(new SimpleDateFormat("dd MMMM yyyy 'à' HH'h'mm"));
            // 2 avril 2010, à 15h30
            formats.add(new SimpleDateFormat("dd MMMM yyyy', à' HH'h'mm"));
            
            // 1.e.r avril 2010, à 17 heures
            formats.add(new SimpleDateFormat("'1.e.r' MMMM yyyy', à' HH 'heures'"));
            // 1.e.r avril 2010 à 17 heures
            formats.add(new SimpleDateFormat("'1.e.r' MMMM yyyy 'à' HH 'heures'"));
            // 1er avril 2010, à 17 heures
            formats.add(new SimpleDateFormat("'1er' MMMM yyyy', à' HH 'heures'"));
            // 1er avril 2010 à 17 heures
            formats.add(new SimpleDateFormat("'1er' MMMM yyyy 'à' HH 'heures'"));
            
            // Sun, 29 Nov 2009 22:07:29 +0100
            formats.add(new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.US));
        }
    }
    
    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        
        String sourcetrim = source.trim();
        if (ND1.equals(sourcetrim) || ND2.equals(sourcetrim)) {
            return null;
        }
        
        for (SimpleDateFormat format : formats) {
            try {
                format.setTimeZone(timezone);
                Date date = format.parse(sourcetrim);
                return date;
            } catch (ParseException e) {
            }
        }
        
        return null;
    }
}
