/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * @author morin
 * @date 18 févr. 2010 11:48:16
 */
public interface MailingService {

    /**
     * Get template document fields names.
     * 
     * @param template template file
     * @return field names
     * @throws VradiException
     * 
     * @deprecated since 0.0.5 can't use non serializable parameters
     */
    @Deprecated
    String[] getDocumentFields(File template) throws VradiException;

    /**
     * Generate offer PDF form given forms with specified template.
     * 
     * @param template template to use to generate PDF
     * @param forms to to generate
     * @param fieldBindings map between template field name and form fields names
     * @return generated pdf files
     * @throws VradiException
     * 
     * @deprecated since 0.0.5 can't use non serializable parameters
     */
    @Deprecated
    List<File> generateFilledDocumentInPDF(File template,
                                            List<Form> forms,
                                            Map<String, String> fieldBindings)
            throws VradiException;

    /**
     * Generate offer PDF form given forms with specified template.
     * 
     * @param template template to use to generate PDF
     * @param forms to to generate
     * @param fieldBindings map between template field name and form fields names
     * @param replace replace already existing generated forms
     * @return generated pdf files
     * @throws VradiException
     * 
     * @deprecated since 0.0.5 can't use non serializable parameters
     */
    @Deprecated
    List<File> generateFilledDocumentInPDF(File template,
                                            List<Form> forms,
                                            Map<String, String> fieldBindings,
                                            boolean replace)
            throws VradiException;

    Session sendMessages(Session session, List<Sending> sendings) throws VradiException;

    Sending sendMessage(Sending sending, String sessionParagraph) throws VradiException;

    Sending sendMessage(Sending sending, String sessionParagraph, String email) throws VradiException;

    void receiveMessages() throws VradiException;

    Session stopSentMail(Session session) throws VradiException;
}

