/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class VradiThesaurusDTO
implements VradiDTO<TreeNode> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VradiThesaurusDTO.class);
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    public static final String EXT_THESAURUS = "Thesaurus";
    public static final String VERSION_THESAURUS = "1.0";
    public static final String TAGS_FIELD = "tags";
    public static final String FQ_TAGS_FIELD = "Thesaurus.tags";
    public static final String COMMENT_FIELD = "comment";
    public static final String FQ_COMMENT_FIELD = "Thesaurus.comment";
    protected boolean toSave = false;
    protected boolean toCreate = false;
    protected boolean toDelete = false;
    protected TreeNode bean;
    protected String name;
    protected String wikittyId;
    protected int formsForThesaurus = 0;
    protected String comment;
    protected VradiThesaurusDTO parentThesaurus;
    protected String tagsAsString;
    protected List<String> tags = new ArrayList<String>();
    protected Map<String, VradiThesaurusDTO> children = new HashMap<String, VradiThesaurusDTO>();
    protected static final Comparator<VradiThesaurusDTO> THESAURUS_COMPARATOR = new Comparator<VradiThesaurusDTO>(){

        @Override
        public int compare(VradiThesaurusDTO o1, VradiThesaurusDTO o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public boolean isRoot() {
        return this.parentThesaurus == null;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        boolean toDeleteOld = this.toDelete;
        this.toDelete = toDelete;
        for (VradiThesaurusDTO child : this.getChildren()) {
            child.setToDelete(toDelete);
        }
        this.propertyChange.firePropertyChange("toDelete", toDeleteOld, toDelete);
    }

    public boolean isToCreate() {
        return this.toCreate;
    }

    public void setToCreate(boolean toCreate) {
        boolean old = this.toCreate;
        this.toCreate = toCreate;
        this.propertyChange.firePropertyChange("toCreate", old, toCreate);
    }

    public boolean isToSave() {
        return this.toSave;
    }

    public void setToSave(boolean toSave) {
        boolean old = this.toSave;
        this.toSave = toSave;
        this.propertyChange.firePropertyChange("toDelete", old, toSave);
    }

    protected void setBean(TreeNode bean) {
        TreeNode old = this.bean;
        this.bean = bean;
        this.propertyChange.firePropertyChange("bean", old, bean);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChange.firePropertyChange("name", old, name);
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        String old = this.wikittyId;
        this.wikittyId = wikittyId;
        this.propertyChange.firePropertyChange("wikittyId", old, wikittyId);
    }

    public VradiThesaurusDTO getParentThesaurus() {
        return this.parentThesaurus;
    }

    public void setParentThesaurus(VradiThesaurusDTO parentThesaurus) {
        VradiThesaurusDTO old = this.parentThesaurus;
        this.parentThesaurus = parentThesaurus;
        this.propertyChange.firePropertyChange("parentThesaurus", old, parentThesaurus);
    }

    public String getTagsAsString() {
        return this.tagsAsString;
    }

    public void setTagsAsString(String values) {
        String old = this.tagsAsString;
        this.tagsAsString = values;
        this.propertyChange.firePropertyChange("tagsAsString", old, this.tagsAsString);
    }

    protected List<String> getTags() {
        return this.tags;
    }

    protected void setTags(List<String> tags) {
        this.tags = tags;
    }

    protected void addTag(String tag) {
        this.tags.add(tag);
    }

    public int getFormsForThesaurus() {
        return this.formsForThesaurus;
    }

    public int decFormsForThesaurus() {
        if (this.parentThesaurus != null) {
            this.parentThesaurus.decFormsForThesaurus();
        }
        return --this.formsForThesaurus;
    }

    public int incFormsForThesaurus() {
        if (this.parentThesaurus != null) {
            this.parentThesaurus.incFormsForThesaurus();
        }
        return ++this.formsForThesaurus;
    }

    protected void setFormsForThesaurus(int formsForThesaurus) {
        this.formsForThesaurus = formsForThesaurus;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.propertyChange.firePropertyChange(COMMENT_FIELD, old, comment);
    }

    public List<VradiThesaurusDTO> getChildren() {
        if (this.children == null) {
            this.children = Collections.emptyMap();
        }
        Collection<VradiThesaurusDTO> children = this.children.values();
        ArrayList<VradiThesaurusDTO> result = new ArrayList<VradiThesaurusDTO>(children);
        Collections.sort(result, THESAURUS_COMPARATOR);
        return result;
    }

    public void addChild(VradiThesaurusDTO element) {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.put(element.getWikittyId(), element);
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public void clearChildren() {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.clear();
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public void removeChild(VradiThesaurusDTO child) {
        Map<String, VradiThesaurusDTO> old = this.children;
        this.children.remove(child.getWikittyId());
        this.propertyChange.firePropertyChange("children", old, this.children);
    }

    public List<String> getChildrenRecursif() {
        ArrayList<String> result = new ArrayList<String>();
        for (VradiThesaurusDTO child : this.getChildren()) {
            result.add(child.getWikittyId());
            result.addAll(child.getChildrenRecursif());
        }
        return result;
    }

    public boolean addChildRecursif(VradiThesaurusDTO child) {
        VradiThesaurusDTO p = child.getParentThesaurus();
        if (this.bean.getWikittyId().equals(p.getWikittyId())) {
            this.addChild(child);
            return true;
        }
        Iterator<VradiThesaurusDTO> i$ = this.getChildren().iterator();
        if (i$.hasNext()) {
            VradiThesaurusDTO c = i$.next();
            return c.addChildRecursif(child);
        }
        return false;
    }

    public boolean removeThesaurusRecursivly(VradiThesaurusDTO toRemove) {
        if (this.children.get(toRemove.getWikittyId()) != null) {
            this.removeChild(toRemove);
            return true;
        }
        Iterator<VradiThesaurusDTO> i$ = this.getChildren().iterator();
        if (i$.hasNext()) {
            VradiThesaurusDTO c = i$.next();
            return c.removeThesaurusRecursivly(toRemove);
        }
        return false;
    }

    public VradiThesaurusDTO findThesaurus(String id) {
        if (this.wikittyId.equals(id)) {
            return this;
        }
        VradiThesaurusDTO child = this.children.get(id);
        if (child != null) {
            return child;
        }
        for (VradiThesaurusDTO c : this.children.values()) {
            VradiThesaurusDTO foundThesaurus = c.findThesaurus(id);
            if (foundThesaurus == null) continue;
            return foundThesaurus;
        }
        return null;
    }

    public boolean isChildOf(String parentId) {
        if (this.parentThesaurus == null) {
            return false;
        }
        if (this.parentThesaurus.getWikittyId().equals(parentId)) {
            return true;
        }
        return this.parentThesaurus.isChildOf(parentId);
    }

    public String getRecursifName() {
        return this.getRecursifName(this.getName());
    }

    protected String getRecursifName(String name) {
        List<VradiThesaurusDTO> children = this.getChildren();
        for (VradiThesaurusDTO child : children) {
            name = name + ", " + child.getRecursifName();
        }
        return name;
    }

    public static final WikittyExtension getThesaurusExtension() {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put(TAGS_FIELD, new FieldType(FieldType.TYPE.STRING, 0, Integer.MAX_VALUE));
        fields.put(COMMENT_FIELD, new FieldType(FieldType.TYPE.STRING, 0, 1));
        WikittyExtension thesaurusExtension = new WikittyExtension(EXT_THESAURUS, VERSION_THESAURUS, "TreeNode", fields);
        return thesaurusExtension;
    }

    public String getParentPath(String pathSeparator) {
        if (this.getParentThesaurus() != null && !this.getParentThesaurus().getName().equals(EXT_THESAURUS)) {
            return this.getParentThesaurus().getParentPath(pathSeparator) + pathSeparator + this.getParentThesaurus().getName();
        }
        return "";
    }

    public String getNamePath(String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getNamePath(pathSeparator) + pathSeparator + this.name;
        }
        return "";
    }

    public String getPath(String pathSeparator) {
        return this.getPath(null, pathSeparator);
    }

    public String getPath(String defName, String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getPath(defName, pathSeparator) + pathSeparator + this.wikittyId;
        }
        if (defName != null) {
            return defName;
        }
        return this.name;
    }

    public String getBuildPath(String pathSeparator) {
        if (this.parentThesaurus != null) {
            return this.parentThesaurus.getBuildPath(pathSeparator) + pathSeparator + "children[@wikittyId=\"" + this.wikittyId + "\"]";
        }
        return "..";
    }

    public VradiThesaurusDTO clone() {
        VradiThesaurusDTO clone = new VradiThesaurusDTO();
        clone.setBean(this.bean);
        clone.setWikittyId(this.wikittyId);
        clone.setToCreate(this.toCreate);
        clone.setToSave(this.toSave);
        clone.setComment(this.comment);
        clone.setName(this.name);
        clone.setFormsForThesaurus(this.formsForThesaurus);
        for (VradiThesaurusDTO child : this.getChildren()) {
            clone.addChild(child.clone(clone));
        }
        clone.setTags(this.tags);
        clone.setTagsAsString(this.tagsAsString);
        return clone;
    }

    protected VradiThesaurusDTO clone(VradiThesaurusDTO parent) {
        VradiThesaurusDTO clone = this.clone();
        clone.setParentThesaurus(parent);
        return clone;
    }

    public void revertFromWikitty() {
        this.reset();
        this.fromWikitty(this.bean);
    }

    @Override
    public void fromWikitty(TreeNode wikitty) {
        this.bean = wikitty;
        this.setName(wikitty.getName());
        this.setWikittyId(wikitty.getWikittyId());
        if (wikitty.getExtensionNames().contains(EXT_THESAURUS)) {
            this.setTags((List)wikitty.getField(EXT_THESAURUS, TAGS_FIELD));
            this.setComment((String)wikitty.getField(EXT_THESAURUS, COMMENT_FIELD));
            String tagAsString = "";
            if (this.tags != null) {
                for (String tag : this.tags) {
                    tagAsString = tagAsString + tag + ", ";
                }
                if (!tagAsString.isEmpty()) {
                    tagAsString = tagAsString.substring(0, tagAsString.length() - 2);
                }
            }
            this.setTagsAsString(tagAsString);
        }
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        try {
            this.formsForThesaurus = service.getNbFormsForThesaurus(this.wikittyId);
            List<TreeNode> childrenTreeNode = service.getChildrenThesaurus(this.wikittyId);
            for (TreeNode child : childrenTreeNode) {
                VradiThesaurusDTO childThesaurus = new VradiThesaurusDTO();
                childThesaurus.fromWikitty(child, this);
                this.addChild(childThesaurus);
            }
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant find thesaurus ", (Throwable)e);
        }
    }

    private void fromWikitty(TreeNode treeNodeChild, VradiThesaurusDTO vradiThesaurusDTO) {
        this.fromWikitty(treeNodeChild);
        this.setParentThesaurus(vradiThesaurusDTO);
    }

    @Override
    public void toWikitty(TreeNode wikitty) {
        wikitty.setName(this.getName());
        VradiThesaurusDTO parentThesaurus = this.getParentThesaurus();
        if (parentThesaurus != null) {
            wikitty.setParent(parentThesaurus.getWikittyId());
        }
        if (!wikitty.getExtensionNames().contains(EXT_THESAURUS)) {
            wikitty.addExtension(VradiThesaurusDTO.getThesaurusExtension());
        }
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        } else {
            this.tags.clear();
        }
        if (this.tagsAsString != null) {
            for (String tag : this.tagsAsString.split(",")) {
                this.addTag(tag.trim());
            }
        }
        wikitty.setField(EXT_THESAURUS, TAGS_FIELD, this.tags);
        wikitty.setField(EXT_THESAURUS, COMMENT_FIELD, (Object)this.comment);
    }

    public TreeNode getBean() {
        this.toWikitty(this.bean);
        return this.bean;
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setName(null);
        this.setTags(null);
        this.setComment(null);
        this.setToDelete(false);
        this.setToSave(false);
        this.setToCreate(false);
        this.setFormsForThesaurus(0);
        this.children = Collections.emptyMap();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}

