package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserBean;

/**
 * @author morin
 *         Date: 7 déc. 2009
 *         Time: 17:34:16
 */
public class VradiVradiUserDTO extends VradiUserBean implements VradiDTO<VradiUser> {

    /**
     * Remplit le bean à partir d'un wikitty.
     *
     * @param wikitty le wikitty source
     */
    @Override
    public void fromWikitty(VradiUser wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setName(wikitty.getName());
            setPassword(wikitty.getPassword());
            setEmail(wikitty.getEmail());
        }
    }

    /**
     * Vide le dto
     */
    @Override
    public void reset() {
        setWikittyId(null);
        setName(null);
        setPassword(null);
        setEmail(null);
    }

    /**
     * Remplit le wikitty à partir du bean.
     *
     * @param wikitty le wikitty a remplir
     */
    @Override
    public void toWikitty(VradiUser wikitty) {
        wikitty.setName(getName());
        wikitty.setPassword(getPassword());
        wikitty.setEmail(getEmail());
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }
}
