/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.services;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author letellier
 */
public class ServiceHelper {

    static {
        // make solr quiet (must be done before any instanciation
        Logger.getLogger("org.apache.solr").setLevel(Level.WARNING);
    }

    /**
     * single instance of storage service
     */
    protected static VradiStorageService vradiStorageService = null;
    /**
     * single instance of xml service
     */
    protected static XmlStreamService xmlStreamService = null;

    public synchronized static VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public synchronized static XmlStreamService getXmlStreamService() {
        if (xmlStreamService == null) {
            xmlStreamService = new XmlStreamServiceImpl();
        }
        return xmlStreamService;
    }
}
