/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingBean;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;

public class VradiSendingDTO
extends SendingBean
implements VradiDTO<Sending> {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);
    VradiClientDTO clientDTO;
    List<VradiFormDTO> formDTOs = new ArrayList<VradiFormDTO>();

    public VradiSendingDTO() {
        this.setFormDTOs(new ArrayList<Form>());
        this.Sending$form = new HashSet();
    }

    @Override
    public void fromWikitty(Sending wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setClientDTO(new VradiClientDTO());
            try {
                this.getClientDTO().fromWikitty(ServiceHelper.getVradiStorageService().getClient(wikitty.getClient()));
                this.setClient(this.getClientDTO().getWikittyId());
            }
            catch (TechnicalException eee) {
                log.error((Object)eee);
            }
            try {
                this.clearForm();
                this.setFormDTOs(ServiceHelper.getVradiStorageService().getForms(new ArrayList<String>(wikitty.getForm())));
            }
            catch (TechnicalException eee) {
                eee.printStackTrace();
            }
            this.setParagraph(wikitty.getParagraph());
            this.setReceptionProof(wikitty.getReceptionProof());
            this.setStatus(wikitty.getStatus());
            this.setReceptionDate(wikitty.getReceptionDate());
            this.setSentDate(wikitty.getSentDate());
        }
    }

    @Override
    public void toWikitty(Sending wikitty) {
        wikitty.setClient(this.getClient());
        wikitty.clearForm();
        for (VradiFormDTO formDTO : this.getFormDTOs()) {
            wikitty.addForm(formDTO.getWikittyId());
        }
        wikitty.setParagraph(this.getParagraph());
        wikitty.setReceptionProof(this.getReceptionProof());
        wikitty.setStatus(this.getStatus());
        wikitty.setReceptionDate(this.getReceptionDate());
        wikitty.setSentDate(this.getSentDate());
    }

    @Override
    public void reset() {
        this.setClientDTO(null);
        this.setClient(null);
        this.setFormDTOs(null);
        this.clearForm();
        this.setParagraph(null);
        this.setReceptionProof(false);
        this.setStatus(null);
        this.setReceptionDate(null);
        this.setSentDate(null);
    }

    public VradiClientDTO getClientDTO() {
        return this.clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        this.clientDTO = clientDTO;
    }

    public List<VradiFormDTO> getFormDTOs() {
        return this.formDTOs;
    }

    public void setFormDTOs(List<Form> forms) {
        if (forms != null) {
            this.formDTOs = new ArrayList<VradiFormDTO>();
            for (Form form : forms) {
                VradiFormDTO formDTO = new VradiFormDTO();
                formDTO.fromWikitty(form);
                this.formDTOs.add(formDTO);
            }
        }
    }
}

