/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sharengo.exceptions.TechnicalException;

public class XmlStreamServiceImpl
implements XmlStreamService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected static String channel = "channel";
    protected static String entry = "entry";
    protected static String feed = "feed";
    protected static String item = "item";
    protected static String opt = "opt";
    protected static String rdf = "rdf";

    @Override
    public List<String> getRSSFields(String url) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRSSFields");
        }
        ArrayList<String> result = new ArrayList<String>();
        SAXBuilder sxb = new SAXBuilder();
        URL rssUrl = null;
        try {
            rssUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        log.debug((Object)"well formed URL");
        Document document = null;
        try {
            document = sxb.build(rssUrl);
        }
        catch (JDOMException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        Element racine = document.getRootElement();
        log.debug((Object)racine.getName());
        Element itemElt = null;
        if (racine.getChild(item) != null) {
            itemElt = racine.getChild(item);
        } else if (racine.getChild(entry) != null) {
            itemElt = racine.getChild(entry);
        } else if (racine.getChild(channel) != null) {
            itemElt = racine.getChild(channel).getChild(item);
        }
        if (itemElt != null) {
            for (Element elt : itemElt.getChildren()) {
                result.add(elt.getName());
            }
        }
        return result;
    }

    public void test(String url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"test");
        }
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(url);
            Document document = sxb.build(rssUrl);
            Element racine = document.getRootElement();
            for (Element elt : racine.getChildren()) {
                this.browseRSS(elt.getChildren());
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void browseRSS(List<Element> list) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"browseRSS");
        }
        for (Element aList : list) {
            Element e = aList;
            if (!e.getTextTrim().isEmpty()) {
                System.out.println(e.getQualifiedName() + " " + e.getTextTrim());
            }
            this.browseRSS(e.getChildren());
        }
        System.out.println("");
    }
}

