/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class InfogeneHelper {

    /**
     * InfogeneHelper :
     * utility class all provided methods are accessible the static way
     */

    private InfogeneHelper() {// empty
}

    /**
     * getId :
     * @param wikitty 
     * @return String 
     */

    public static String getId(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
        return value;
}

    /**
     * setId :
     * @param wikitty 
     * @param id 
     * @return String 
     */

    public static String setId(Wikitty wikitty, String id) {
        String oldValue = getId(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID, id);
        return oldValue;
}

    /**
     * getObjet :
     * @param wikitty 
     * @return String 
     */

    public static String getObjet(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
        return value;
}

    /**
     * setObjet :
     * @param wikitty 
     * @param objet 
     * @return String 
     */

    public static String setObjet(Wikitty wikitty, String objet) {
        String oldValue = getObjet(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET, objet);
        return oldValue;
}

    /**
     * getCreationDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getCreationDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
        return value;
}

    /**
     * setCreationDate :
     * @param wikitty 
     * @param creationDate 
     * @return Date 
     */

    public static Date setCreationDate(Wikitty wikitty, Date creationDate) {
        Date oldValue = getCreationDate(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE, creationDate);
        return oldValue;
}

    /**
     * getSourceURL :
     * @param wikitty 
     * @return String 
     */

    public static String getSourceURL(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
        return value;
}

    /**
     * setSourceURL :
     * @param wikitty 
     * @param sourceURL 
     * @return String 
     */

    public static String setSourceURL(Wikitty wikitty, String sourceURL) {
        String oldValue = getSourceURL(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL, sourceURL);
        return oldValue;
}

    /**
     * getSourceText :
     * @param wikitty 
     * @return String 
     */

    public static String getSourceText(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
        return value;
}

    /**
     * setSourceText :
     * @param wikitty 
     * @param sourceText 
     * @return String 
     */

    public static String setSourceText(Wikitty wikitty, String sourceText) {
        String oldValue = getSourceText(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT, sourceText);
        return oldValue;
}

    /**
     * getEntity :
     * @param wikitty 
     * @return String 
     */

    public static String getEntity(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
        return value;
}

    /**
     * setEntity :
     * @param wikitty 
     * @param entity 
     * @return String 
     */

    public static String setEntity(Wikitty wikitty, String entity) {
        String oldValue = getEntity(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY, entity);
        return oldValue;
}

    /**
     * getCountry :
     * @param wikitty 
     * @return String 
     */

    public static String getCountry(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
        return value;
}

    /**
     * setCountry :
     * @param wikitty 
     * @param country 
     * @return String 
     */

    public static String setCountry(Wikitty wikitty, String country) {
        String oldValue = getCountry(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY, country);
        return oldValue;
}

    /**
     * getDepartment :
     * @param wikitty 
     * @return String 
     */

    public static String getDepartment(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
        return value;
}

    /**
     * setDepartment :
     * @param wikitty 
     * @param department 
     * @return String 
     */

    public static String setDepartment(Wikitty wikitty, String department) {
        String oldValue = getDepartment(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT, department);
        return oldValue;
}

    /**
     * getDescription :
     * @param wikitty 
     * @return String 
     */

    public static String getDescription(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
        return value;
}

    /**
     * setDescription :
     * @param wikitty 
     * @param description 
     * @return String 
     */

    public static String setDescription(Wikitty wikitty, String description) {
        String oldValue = getDescription(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION, description);
        return oldValue;
}

    /**
     * getTag :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getTag(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, String.class);
        return result;
}

    /**
     * setTag :
     * @param wikitty 
     * @param tag 
     */

    public static void setTag(Wikitty wikitty, Set<String> tag) {
        clearTag(wikitty);
        addAllTag(wikitty, tag);
}

    /**
     * addAllTag :
     * @param wikitty 
     * @param tag 
     */

    public static void addAllTag(Wikitty wikitty, Set<String> tag) {
        if(tag != null){
            for (String id:tag){
                addTag(wikitty, id);
            }
        }
}

    /**
     * addTag :
     * @param wikitty 
     * @param element 
     */

    public static void addTag(Wikitty wikitty, String element) {
        wikitty.addToField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, element);
}

    /**
     * removeTag :
     * @param wikitty 
     * @param element 
     */

    public static void removeTag(Wikitty wikitty, String element) {
        wikitty.removeFromField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, element);
}

    /**
     * clearTag :
     * @param wikitty 
     */

    public static void clearTag(Wikitty wikitty) {
        wikitty.clearField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
}

    /**
     * getStatus :
     * @param wikitty 
     * @return String 
     */

    public static String getStatus(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
        return value;
}

    /**
     * setStatus :
     * @param wikitty 
     * @param status 
     * @return String 
     */

    public static String setStatus(Wikitty wikitty, String status) {
        String oldValue = getStatus(wikitty);
        wikitty.setField(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS, status);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
            Object f2 = w2.getFieldAsObject(Infogene.EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Infogene.EXT_INFOGENE);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : InfogeneAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //InfogeneHelper
