/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  class FormHelper {

    /**
     * FormHelper :
     * utility class all provided methods are accessible the static way
     */

    private FormHelper() {// empty
}

    /**
     * getDatePub :
     * @param wikitty 
     * @return Date 
     */

    public static Date getDatePub(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Form.EXT_FORM, Form.FIELD_FORM_DATEPUB);
        return value;
}

    /**
     * setDatePub :
     * @param wikitty 
     * @param datePub 
     * @return Date 
     */

    public static Date setDatePub(Wikitty wikitty, Date datePub) {
        Date oldValue = getDatePub(wikitty);
        wikitty.setField(Form.EXT_FORM, Form.FIELD_FORM_DATEPUB, datePub);
        return oldValue;
}

    /**
     * getDatePeremption :
     * @param wikitty 
     * @return Date 
     */

    public static Date getDatePeremption(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Form.EXT_FORM, Form.FIELD_FORM_DATEPEREMPTION);
        return value;
}

    /**
     * setDatePeremption :
     * @param wikitty 
     * @param datePeremption 
     * @return Date 
     */

    public static Date setDatePeremption(Wikitty wikitty, Date datePeremption) {
        Date oldValue = getDatePeremption(wikitty);
        wikitty.setField(Form.EXT_FORM, Form.FIELD_FORM_DATEPEREMPTION, datePeremption);
        return oldValue;
}

    /**
     * getFiles :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getFiles(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Form.EXT_FORM, Form.FIELD_FORM_FILES, String.class);
        return result;
}

    /**
     * addFiles :
     * @param wikitty 
     * @param element 
     */

    public static void addFiles(Wikitty wikitty, String element) {
        wikitty.addToField(Form.EXT_FORM, Form.FIELD_FORM_FILES, element);
}

    /**
     * removeFiles :
     * @param wikitty 
     * @param element 
     */

    public static void removeFiles(Wikitty wikitty, String element) {
        wikitty.removeFromField(Form.EXT_FORM, Form.FIELD_FORM_FILES, element);
}

    /**
     * clearFiles :
     * @param wikitty 
     */

    public static void clearFiles(Wikitty wikitty) {
        wikitty.clearField(Form.EXT_FORM, Form.FIELD_FORM_FILES);
}

    /**
     * getAttachments :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAttachments(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS, String.class);
        return result;
}

    /**
     * addAttachments :
     * @param wikitty 
     * @param element 
     */

    public static void addAttachments(Wikitty wikitty, String element) {
        wikitty.addToField(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS, element);
}

    /**
     * removeAttachments :
     * @param wikitty 
     * @param element 
     */

    public static void removeAttachments(Wikitty wikitty, String element) {
        wikitty.removeFromField(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS, element);
}

    /**
     * clearAttachments :
     * @param wikitty 
     */

    public static void clearAttachments(Wikitty wikitty) {
        wikitty.clearField(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS);
}

    /**
     * getImportContentHash :
     * @param wikitty 
     * @return String 
     */

    public static String getImportContentHash(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Form.EXT_FORM, Form.FIELD_FORM_IMPORTCONTENTHASH);
        return value;
}

    /**
     * setImportContentHash :
     * @param wikitty 
     * @param importContentHash 
     * @return String 
     */

    public static String setImportContentHash(Wikitty wikitty, String importContentHash) {
        String oldValue = getImportContentHash(wikitty);
        wikitty.setField(Form.EXT_FORM, Form.FIELD_FORM_IMPORTCONTENTHASH, importContentHash);
        return oldValue;
}

    /**
     * getXmlStream :
     * @param wikitty 
     * @return String 
     */

    public static String getXmlStream(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Form.EXT_FORM, Form.FIELD_FORM_XMLSTREAM);
        return value;
}

    /**
     * setXmlStream :
     * @param wikitty 
     * @param xmlStream 
     * @return String 
     */

    public static String setXmlStream(Wikitty wikitty, String xmlStream) {
        String oldValue = getXmlStream(wikitty);
        wikitty.setField(Form.EXT_FORM, Form.FIELD_FORM_XMLSTREAM, xmlStream);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_DATEPUB);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_DATEPUB);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_DATEPEREMPTION);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_DATEPEREMPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_FILES);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_FILES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_ATTACHMENTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_IMPORTCONTENTHASH);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_IMPORTCONTENTHASH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_XMLSTREAM);
            Object f2 = w2.getFieldAsObject(Form.EXT_FORM, Form.FIELD_FORM_XMLSTREAM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Form.EXT_FORM);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : FormAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //FormHelper
