/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  class SendingHelper {

    /**
     * SendingHelper :
     * utility class all provided methods are accessible the static way
     */

    private SendingHelper() {// empty
}

    /**
     * getSentDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getSentDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
        return value;
}

    /**
     * setSentDate :
     * @param wikitty 
     * @param sentDate 
     * @return Date 
     */

    public static Date setSentDate(Wikitty wikitty, Date sentDate) {
        Date oldValue = getSentDate(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE, sentDate);
        return oldValue;
}

    /**
     * getReceptionDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getReceptionDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
        return value;
}

    /**
     * setReceptionDate :
     * @param wikitty 
     * @param receptionDate 
     * @return Date 
     */

    public static Date setReceptionDate(Wikitty wikitty, Date receptionDate) {
        Date oldValue = getReceptionDate(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE, receptionDate);
        return oldValue;
}

    /**
     * getParagraph :
     * @param wikitty 
     * @return String 
     */

    public static String getParagraph(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
        return value;
}

    /**
     * setParagraph :
     * @param wikitty 
     * @param paragraph 
     * @return String 
     */

    public static String setParagraph(Wikitty wikitty, String paragraph) {
        String oldValue = getParagraph(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH, paragraph);
        return oldValue;
}

    /**
     * getReceptionProof :
     * @param wikitty 
     * @return boolean 
     */

    public static boolean getReceptionProof(Wikitty wikitty) {
        boolean value = wikitty.getFieldAsBoolean(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
        return value;
}

    /**
     * setReceptionProof :
     * @param wikitty 
     * @param receptionProof 
     * @return boolean 
     */

    public static boolean setReceptionProof(Wikitty wikitty, boolean receptionProof) {
        boolean oldValue = getReceptionProof(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF, receptionProof);
        return oldValue;
}

    /**
     * getStatus :
     * @param wikitty 
     * @return int 
     */

    public static int getStatus(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
        return value;
}

    /**
     * setStatus :
     * @param wikitty 
     * @param status 
     * @return int 
     */

    public static int setStatus(Wikitty wikitty, int status) {
        int oldValue = getStatus(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS, status);
        return oldValue;
}

    /**
     * getMessageId :
     * @param wikitty 
     * @return String 
     */

    public static String getMessageId(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
        return value;
}

    /**
     * setMessageId :
     * @param wikitty 
     * @param messageId 
     * @return String 
     */

    public static String setMessageId(Wikitty wikitty, String messageId) {
        String oldValue = getMessageId(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID, messageId);
        return oldValue;
}

    /**
     * getForm :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getForm(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM, String.class);
        return result;
}

    /**
     * addForm :
     * @param wikitty 
     * @param element 
     */

    public static void addForm(Wikitty wikitty, String element) {
        wikitty.addToField(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM, element);
}

    /**
     * removeForm :
     * @param wikitty 
     * @param element 
     */

    public static void removeForm(Wikitty wikitty, String element) {
        wikitty.removeFromField(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM, element);
}

    /**
     * clearForm :
     * @param wikitty 
     */

    public static void clearForm(Wikitty wikitty) {
        wikitty.clearField(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM);
}

    /**
     * getUser :
     * @param wikitty 
     * @return String 
     */

    public static String getUser(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
        return value;
}

    /**
     * setUser :
     * @param wikitty 
     * @param user 
     * @return String 
     */

    public static String setUser(Wikitty wikitty, String user) {
        String oldValue = getUser(wikitty);
        wikitty.setField(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER, user);
        return oldValue;
}

    /**
     * getDeletedForms :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getDeletedForms(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, String.class);
        return result;
}

    /**
     * addDeletedForms :
     * @param wikitty 
     * @param element 
     */

    public static void addDeletedForms(Wikitty wikitty, String element) {
        wikitty.addToField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, element);
}

    /**
     * removeDeletedForms :
     * @param wikitty 
     * @param element 
     */

    public static void removeDeletedForms(Wikitty wikitty, String element) {
        wikitty.removeFromField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, element);
}

    /**
     * clearDeletedForms :
     * @param wikitty 
     */

    public static void clearDeletedForms(Wikitty wikitty) {
        wikitty.clearField(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_FORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
            Object f2 = w2.getFieldAsObject(Sending.EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Sending.EXT_SENDING);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : SendingAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //SendingHelper
