/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeHelper;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class RootThesaurusAbstract extends BusinessEntityWikitty implements RootThesaurus, TreeNode {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionRootThesaurus;
    /**
     * getName :
     * @return String 
     */

    public String getName() {
        String value = TreeNodeHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    public void setName(String name) {
        String oldValue = getName();
        TreeNodeHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_NAME, oldValue, getName());
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    public Set<String> getAttachment() {
        Set<String> result = TreeNodeHelper.getAttachment(getWikitty());
        return result;
}

    /**
     * addAttachment :
     * @param element 
     */

    public void addAttachment(String element) {
        TreeNodeHelper.addAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * removeAttachment :
     * @param element 
     */

    public void removeAttachment(String element) {
        TreeNodeHelper.removeAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * clearAttachment :
     */

    public void clearAttachment() {
        TreeNodeHelper.clearAttachment(getWikitty());
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * getParent :
     * @return String 
     */

    public String getParent() {
        String value = TreeNodeHelper.getParent(getWikitty());
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    public void setParent(String parent) {
        String oldValue = getParent();
        TreeNodeHelper.setParent(getWikitty(), parent);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_PARENT, oldValue, getParent());
}

    /**
     * RootThesaurusAbstract :
     */

    public RootThesaurusAbstract() {
        super();
}

    /**
     * RootThesaurusAbstract :
     * @param wikitty 
     */

    public RootThesaurusAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * RootThesaurusAbstract :
     * @param businessEntityWikitty 
     */

    public RootThesaurusAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionRootThesaurus =
                new WikittyExtension(EXT_ROOTTHESAURUS,
                                     "1.0", // version
                                     TreeNode.EXT_TREENODE,
                                     WikittyUtil.buildFieldMapExtension( // building field map
));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(TreeNodeAbstract.extensions); 
        // current after requires ones

        exts.add(extensionRootThesaurus);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //RootThesaurusAbstract
