package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Vradi user.
 * 
 * Changes :
 * * 2.0 : inheritance from wikittyuser
 * * 1.0 initial version
 */
public class VradiUserHelper extends VradiUserImpl {

    private static final long serialVersionUID = 827378632L;


    /**
     * This class is not instanciable, it's just helper
     */
    private VradiUserHelper() {
    }


    static public void setEmail(Wikitty w, String email) {
        w.setField(EXT_VRADIUSER, VradiUser.FIELD_VRADIUSER_EMAIL, email);
    }

    static public String getEmail(Wikitty w) {
        String result = w.getFieldAsString(EXT_VRADIUSER, VradiUser.FIELD_VRADIUSER_EMAIL);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_VRADIUSER);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_VRADIUSER, VradiUser.FIELD_VRADIUSER_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_VRADIUSER, VradiUser.FIELD_VRADIUSER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //VradiUserHelper
