package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class StatusAbstract extends BusinessEntityWikitty implements Status {

    private static final long serialVersionUID = -1476771946L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionStatus =
        new WikittyExtension(EXT_STATUS, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"Numeric value",
				"String description",
				"boolean modifiable"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionStatus);

        extensions = Collections.unmodifiableList(exts);
    }

	public StatusAbstract() {
		super();
	}

    public StatusAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public StatusAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_STATUS, FIELD_STATUS_NAME);
        getWikitty().setField(EXT_STATUS, FIELD_STATUS_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_STATUS_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_STATUS, FIELD_STATUS_NAME);
        return result;
    }


    public void setValue(int value) {
        Object oldValue = getField(EXT_STATUS, FIELD_STATUS_VALUE);
        getWikitty().setField(EXT_STATUS, FIELD_STATUS_VALUE, value);
        getPropertyChangeSupport().firePropertyChange(FIELD_STATUS_VALUE, oldValue, value);
    }

    public int getValue() {
        int result = getWikitty().getFieldAsInt(EXT_STATUS, FIELD_STATUS_VALUE);
        return result;
    }


    public void setDescription(String description) {
        Object oldValue = getField(EXT_STATUS, FIELD_STATUS_DESCRIPTION);
        getWikitty().setField(EXT_STATUS, FIELD_STATUS_DESCRIPTION, description);
        getPropertyChangeSupport().firePropertyChange(FIELD_STATUS_DESCRIPTION, oldValue, description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_STATUS, FIELD_STATUS_DESCRIPTION);
        return result;
    }


    public void setModifiable(boolean modifiable) {
        Object oldValue = getField(EXT_STATUS, FIELD_STATUS_MODIFIABLE);
        getWikitty().setField(EXT_STATUS, FIELD_STATUS_MODIFIABLE, modifiable);
        getPropertyChangeSupport().firePropertyChange(FIELD_STATUS_MODIFIABLE, oldValue, modifiable);
    }

    public boolean getModifiable() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_STATUS, FIELD_STATUS_MODIFIABLE);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, FIELD_STATUS_NAME);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, FIELD_STATUS_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, FIELD_STATUS_VALUE);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, FIELD_STATUS_VALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, FIELD_STATUS_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, FIELD_STATUS_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, FIELD_STATUS_MODIFIABLE);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, FIELD_STATUS_MODIFIABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //StatusAbstract
