package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class SessionHelper extends SessionImpl {

    private static final long serialVersionUID = 1999397049L;


    /**
     * This class is not instanciable, it's just helper
     */
    private SessionHelper() {
    }


    static public void setSessionDate(Wikitty w, Date sessionDate) {
        w.setField(EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE, sessionDate);
    }

    static public Date getSessionDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
        return result;
    }


    static public void setNum(Wikitty w, int num) {
        w.setField(EXT_SESSION, Session.FIELD_SESSION_NUM, num);
    }

    static public int getNum(Wikitty w) {
        int result = w.getFieldAsInt(EXT_SESSION, Session.FIELD_SESSION_NUM);
        return result;
    }


    static public void setStatus(Wikitty w, int status) {
        w.setField(EXT_SESSION, Session.FIELD_SESSION_STATUS, status);
    }

    static public int getStatus(Wikitty w) {
        int result = w.getFieldAsInt(EXT_SESSION, Session.FIELD_SESSION_STATUS);
        return result;
    }


    static public void setParagraph(Wikitty w, String paragraph) {
        w.setField(EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH, paragraph);
    }

    static public String getParagraph(Wikitty w) {
        String result = w.getFieldAsString(EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
        return result;
    }

    static public Set<String> getSending(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_SESSION, Session.FIELD_SESSION_SENDING, String.class);
        return result;
    }

    static public void addSending(Wikitty w, String element) {
        w.addToField(EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
    }
    
    static public void removeSending(Wikitty w, String element) {
        w.removeFromField(EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
    }
    
    static public void clearSending(Wikitty w) {
        w.clearField(EXT_SESSION, Session.FIELD_SESSION_SENDING);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_SESSION);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_NUM);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_NUM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_SENDING);
            Object f2 = w2.getFieldAsObject(EXT_SESSION, Session.FIELD_SESSION_SENDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SessionHelper
