package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Root thesaurus extension.
 * 
 * Cannot extends Thesaurus due to not-null rootId violation.
 * 
 * History:
 *  * 1.0 : initial version
 */
public abstract class RootThesaurusAbstract extends TreeNodeImpl implements RootThesaurus, TreeNode {

    private static final long serialVersionUID = -117865581L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionRootThesaurus =
        new WikittyExtension(EXT_ROOTTHESAURUS, "1.0", TreeNode.EXT_TREENODE,
		    WikittyUtil.buildFieldMapExtension());
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(TreeNodeAbstract.extensions);
        // current after requires ones
        exts.add(extensionRootThesaurus);

        extensions = Collections.unmodifiableList(exts);
    }

	public RootThesaurusAbstract() {
		super();
	}

    public RootThesaurusAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public RootThesaurusAbstract(Wikitty wi) {
		super(wi);
	}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;

        return result;
    }

} //RootThesaurusAbstract
