package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class StatusImpl extends BusinessEntityWikitty implements Status {

    private static final long serialVersionUID = -1476771946L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionStatus =
        new WikittyExtension(EXT_STATUS, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"Numeric value unique",
				"String description unique",
				"boolean modifiable unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionStatus);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public StatusImpl() {
		super();
	}

    public StatusImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public StatusImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_STATUS, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_STATUS, "name");
        return result;
    }


    public void setValue(int value) {
        getWikitty().setField(EXT_STATUS, "value", value);
    }

    public int getValue() {
        int result = getWikitty().getFieldAsInt(EXT_STATUS, "value");
        return result;
    }


    public void setDescription(String description) {
        getWikitty().setField(EXT_STATUS, "description", description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_STATUS, "description");
        return result;
    }


    public void setModifiable(boolean modifiable) {
        getWikitty().setField(EXT_STATUS, "modifiable", modifiable);
    }

    public boolean getModifiable() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_STATUS, "modifiable");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //StatusImpl
