package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class InfogeneImpl extends BusinessEntityWikitty implements Infogene {

    private static final long serialVersionUID = -1621839580L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionInfogene =
        new WikittyExtension(EXT_INFOGENE, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String id unique",
				"String objet unique",
				"Date creationDate unique",
				"String sourceURL unique",
				"String sourceText unique",
				"String entity unique",
				"String country unique",
				"String department unique",
				"String description unique",
				"Wikitty status unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionInfogene);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public InfogeneImpl() {
		super();
	}

    public InfogeneImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public InfogeneImpl(Wikitty wi) {
		super(wi);
	}


    public void setId(String id) {
        getWikitty().setField(EXT_INFOGENE, "id", id);
    }

    public String getId() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "id");
        return result;
    }


    public void setObjet(String objet) {
        getWikitty().setField(EXT_INFOGENE, "objet", objet);
    }

    public String getObjet() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "objet");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_INFOGENE, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_INFOGENE, "creationDate");
        return result;
    }


    public void setSourceURL(String sourceURL) {
        getWikitty().setField(EXT_INFOGENE, "sourceURL", sourceURL);
    }

    public String getSourceURL() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceURL");
        return result;
    }


    public void setSourceText(String sourceText) {
        getWikitty().setField(EXT_INFOGENE, "sourceText", sourceText);
    }

    public String getSourceText() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "sourceText");
        return result;
    }


    public void setEntity(String entity) {
        getWikitty().setField(EXT_INFOGENE, "entity", entity);
    }

    public String getEntity() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "entity");
        return result;
    }


    public void setCountry(String country) {
        getWikitty().setField(EXT_INFOGENE, "country", country);
    }

    public String getCountry() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "country");
        return result;
    }


    public void setDepartment(String department) {
        getWikitty().setField(EXT_INFOGENE, "department", department);
    }

    public String getDepartment() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "department");
        return result;
    }


    public void setDescription(String description) {
        getWikitty().setField(EXT_INFOGENE, "description", description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "description");
        return result;
    }


    public void setStatus(String status) {
        getWikitty().setField(EXT_INFOGENE, "status", status);
    }

    public String getStatus() {
        String result = getWikitty().getFieldAsString(EXT_INFOGENE, "status");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //InfogeneImpl
