package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class VradiUserImpl extends BusinessEntityWikitty implements VradiUser {

    private static final long serialVersionUID = 1016954888L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionVradiUser =
        new WikittyExtension(EXT_VRADIUSER, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"String password unique",
				"String email unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionVradiUser);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public VradiUserImpl() {
		super();
	}

    public VradiUserImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public VradiUserImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_VRADIUSER, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_VRADIUSER, "name");
        return result;
    }


    public void setPassword(String password) {
        getWikitty().setField(EXT_VRADIUSER, "password", password);
    }

    public String getPassword() {
        String result = getWikitty().getFieldAsString(EXT_VRADIUSER, "password");
        return result;
    }


    public void setEmail(String email) {
        getWikitty().setField(EXT_VRADIUSER, "email", email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_VRADIUSER, "email");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //VradiUserImpl
