/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.entities;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.FieldType.TYPE;

/**
 *
 * @author letellier
 */
public enum FieldTypeEnum {
    STRING(FieldType.TYPE.STRING, "Chaine", 0, 1),
    TEXT(FieldType.TYPE.STRING, "Texte", 0, 1),
    DATE(FieldType.TYPE.DATE, "Date", 1, 1),
    EMAIL(FieldType.TYPE.STRING, "Email", 0, 1),
    URL(FieldType.TYPE.STRING, "Url", 0, 1),
    NUMBER(FieldType.TYPE.NUMERIC, "Nombre", 1, 1);

    protected String TAG_VALUE = "use";
    protected String tagValue;
    protected FieldType type;
    FieldTypeEnum(TYPE type, String tagValue, int min, int max) {
        this.tagValue = tagValue;
        this.type = new FieldType(type, min, max);
        this.type.addTagValue(TAG_VALUE, tagValue);
    }

    public String getTagValue(){
        return tagValue;
    }
    
    public FieldType getFieldType(){
        return type;
    }

    public boolean isType(FieldType type){
        return tagValue.equals(type.getTagValue(TAG_VALUE));
    }

    @Override
    public String toString(){
        return getTagValue();
    }
}
