/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormElement;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="select", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.SelectTag", description="Render HTML select box providing content from remote call via AJAX")
public class Select
extends AbstractFormElement {
    public static final String TEMPLATE = "select";
    public static final String TEMPLATE_CLOSE = "select-close";
    public static final String COMPONENT_NAME = Select.class.getName();
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "select";
    protected String emptyOption;
    protected String headerKey;
    protected String headerValue;
    protected String list;
    protected String listKey;
    protected String listValue;

    public Select(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return "select";
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", "select");
        if (this.emptyOption != null) {
            this.addParameter("emptyOption", this.findValue(this.emptyOption, Boolean.class));
        }
        if (this.headerKey != null && this.headerValue != null) {
            this.addParameter("headerKey", this.findString(this.headerKey));
            this.addParameter("headerValue", this.findString(this.headerValue));
        }
        if (this.list != null) {
            this.addParameter("list", this.findString(this.list));
        }
        if (this.listKey != null) {
            this.addParameter("listKey", this.findString(this.listKey));
        }
        if (this.listValue != null) {
            this.addParameter("listValue", this.findString(this.listValue));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "select_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(name="emptyOption", description="Add an empty option after the header option", type="String", defaultValue="false")
    public void setEmptyOption(String emptyOption) {
        this.emptyOption = emptyOption;
    }

    @StrutsTagAttribute(name="headerKey", description="Key for list header option. Must not be empty", type="String", defaultValue="")
    public void setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
    }

    @StrutsTagAttribute(name="headerValue", description="Value for list header option. Must not be empty", type="String", defaultValue="")
    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @StrutsTagAttribute(description="Name of the JSON list", required=false)
    public void setList(String list) {
        this.list = list;
    }

    @StrutsTagAttribute(description=" Property of list objects to get field value from", required=false)
    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    @StrutsTagAttribute(description="Property of list objects to get field content from", required=false)
    public void setListValue(String listValue) {
        this.listValue = listValue;
    }
}

