/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteQueue {
    public static final long DEFAULT_REINCARNATE_TIMEOUT = 3000L;
    private final File myDatabaseFile;
    private final ThreadFactory myThreadFactory;
    private volatile Thread myThread;
    private final Object myLock = new Object();
    protected Collection<SQLiteJob> myJobs;
    private boolean myStopRequested;
    private boolean myStopRequired;
    private SQLiteJob myCurrentJob;
    private SQLiteConnection myConnection;

    public SQLiteQueue() {
        this(null);
    }

    public SQLiteQueue(File databaseFile) {
        this(databaseFile, Executors.defaultThreadFactory());
    }

    public SQLiteQueue(File databaseFile, ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.myDatabaseFile = databaseFile;
        this.myThreadFactory = threadFactory;
    }

    public String toString() {
        return "SQLiteQueue[" + (this.myDatabaseFile == null ? "" : this.myDatabaseFile.getName()) + "]";
    }

    public File getDatabaseFile() {
        return this.myDatabaseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteQueue start() {
        Thread thread;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myThread != null || this.myStopRequested) {
                Internal.logWarn(this, this.myStopRequested ? "stopped" : "already started");
                return this;
            }
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "starting");
            }
            if ((thread = this.myThreadFactory.newThread(new Runnable(){

                public void run() {
                    SQLiteQueue.this.runQueue();
                }
            })) == null) {
                throw new IllegalStateException(this + " cannot create new thread");
            }
            String name = thread.getName();
            if (name == null || name.startsWith("Thread-") || name.startsWith("pool-")) {
                thread.setName(this.toString());
            }
            this.myThread = thread;
        }
        thread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteQueue stop(boolean gracefully) {
        SQLiteJob currentJob = null;
        Object object = this.myLock;
        synchronized (object) {
            if (!gracefully) {
                if (!this.myStopRequired && this.myStopRequested && Internal.isFineLogging()) {
                    Internal.logFine(this, "now stopping non-gracefully");
                }
                this.myStopRequired = true;
            }
            if (this.myStopRequested) {
                return this;
            }
            if (Internal.isFineLogging()) {
                Internal.logFine(this, gracefully ? "stopping gracefully" : "stopping non-gracefully");
            }
            this.myStopRequested = true;
            if (this.myStopRequired) {
                currentJob = this.myCurrentJob;
            }
            this.myLock.notify();
        }
        if (currentJob != null) {
            currentJob.cancel(true);
        }
        return this;
    }

    public SQLiteQueue join() throws InterruptedException {
        Thread thread;
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "waiting for queue to stop");
        }
        if ((thread = this.myThread) == Thread.currentThread()) {
            throw new IllegalStateException();
        }
        if (thread != null) {
            thread.join();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, J extends SQLiteJob<T>> J execute(J job) {
        if (job == null) {
            throw new NullPointerException();
        }
        boolean cancel = false;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopRequested) {
                Internal.logFine(this, "job not executed: " + job);
                cancel = true;
            } else {
                if (Internal.isFineLogging()) {
                    Internal.logFine(this, "queueing " + job);
                }
                this.addJob(job);
                this.myLock.notify();
            }
        }
        if (cancel) {
            job.cancel(true);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteQueue flush() throws InterruptedException {
        Object object = this.myLock;
        synchronized (object) {
            while (!this.isJobQueueEmpty() || this.myCurrentJob != null) {
                this.myLock.wait(1000L);
                this.myLock.notify();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStopRequested;
        }
    }

    public boolean isDatabaseThread() {
        return Thread.currentThread() == this.myThread;
    }

    protected void addJob(SQLiteJob job) {
        assert (Thread.holdsLock(this.myLock)) : job;
        Collection<SQLiteJob> jobs = this.myJobs;
        if (jobs == null) {
            this.myJobs = jobs = this.createJobCollection();
        }
        jobs.add(job);
    }

    protected Collection<SQLiteJob> createJobCollection() {
        return new ArrayList<SQLiteJob>();
    }

    protected boolean isJobQueueEmpty() {
        assert (Thread.holdsLock(this.myLock));
        return this.myJobs == null || this.myJobs.isEmpty();
    }

    protected List<SQLiteJob> removeJobsClearQueue() {
        assert (Thread.holdsLock(this.myLock));
        if (this.myJobs == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLiteJob> r = new ArrayList<SQLiteJob>(this.myJobs);
        this.myJobs.clear();
        return r;
    }

    protected SQLiteJob selectJob() {
        assert (Thread.holdsLock(this.myLock));
        Collection<SQLiteJob> jobs = this.myJobs;
        if (jobs == null || jobs.isEmpty()) {
            return null;
        }
        Iterator<SQLiteJob> ii = jobs.iterator();
        SQLiteJob r = ii.next();
        ii.remove();
        return r;
    }

    protected SQLiteConnection openConnection() throws SQLiteException {
        SQLiteConnection connection = new SQLiteConnection(this.myDatabaseFile);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "opening " + connection);
        }
        try {
            connection.open();
        }
        catch (SQLiteException e) {
            Internal.logWarn("cannot open " + connection, e);
            throw e;
        }
        return connection;
    }

    protected void initConnection(SQLiteConnection connection) throws SQLiteException {
    }

    protected void disposeConnection(SQLiteConnection connection) {
        try {
            if (connection != null) {
                if (Internal.isFineLogging()) {
                    Internal.logFine(this, "disposing " + connection);
                }
                connection.dispose();
            }
        }
        catch (Exception e) {
            Internal.log(Level.SEVERE, this, "error disposing connection", e);
        }
    }

    protected void rollback() {
        block3: {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "rolling back transaction");
            }
            try {
                this.myConnection.exec("ROLLBACK");
            }
            catch (SQLiteException e) {
                if (!Internal.isFineLogging()) break block3;
                Internal.logFine(this, "exception during rollback: " + e);
            }
        }
    }

    protected void executeJob(SQLiteJob job) throws Throwable {
        if (job == null) {
            return;
        }
        SQLiteConnection connection = this.myConnection;
        if (connection == null) {
            throw new IllegalStateException(this + ": executeJob: no connection");
        }
        try {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "executing " + job);
            }
            job.execute(connection, this);
            this.afterExecute(job);
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "finished executing " + job);
            }
        }
        catch (Throwable e) {
            this.handleJobException(job, e);
        }
    }

    protected void afterExecute(SQLiteJob job) throws Throwable {
        assert (job.isDone()) : job;
        if (job.isCancelled()) {
            this.rollback();
        }
    }

    protected void handleJobException(SQLiteJob job, Throwable e) throws Throwable {
        this.rollback();
        if (e instanceof ThreadDeath) {
            throw (ThreadDeath)e;
        }
    }

    protected long getReincarnationTimeout() {
        return 3000L;
    }

    protected boolean isReincarnationPossible() {
        return this.myDatabaseFile != null && this.getReincarnationTimeout() >= 0L;
    }

    protected void reincarnate(final long reincarnateTimeout) {
        Internal.logWarn(this, "stopped abnormally, reincarnating in " + reincarnateTimeout + "ms");
        Thread reincarnator = this.myThreadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = SQLiteQueue.this.myLock;
                    synchronized (object) {
                        long now = System.currentTimeMillis();
                        long wake = now + reincarnateTimeout;
                        while (now < wake) {
                            SQLiteQueue.this.myLock.wait(wake - now);
                            if (SQLiteQueue.this.myStopRequested) {
                                Internal.logWarn(SQLiteQueue.this, "stopped, will not reincarnate");
                                return;
                            }
                            now = System.currentTimeMillis();
                        }
                    }
                    SQLiteQueue.this.start();
                }
                catch (InterruptedException e) {
                    Internal.log(Level.WARNING, SQLiteQueue.this, "not reincarnated", e);
                }
            }
        });
        reincarnator.setName("reincarnate " + this + " in " + reincarnateTimeout + "ms");
        reincarnator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueue() {
        try {
            this.queueFunction();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Internal.logWarn(this + " interrupted", e);
        }
        catch (Throwable e) {
            Internal.log(Level.SEVERE, this, "error running job queue", e);
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
        }
        finally {
            this.threadStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFunction() throws Throwable {
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "started");
        }
        this.disposeConnection(this.myConnection);
        this.myConnection = null;
        this.myConnection = this.openConnection();
        this.initConnection(this.myConnection);
        while (true) {
            SQLiteJob job;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myCurrentJob = null;
                this.myLock.notify();
                while (true) {
                    if (this.myStopRequested && (this.myStopRequired || this.isJobQueueEmpty())) {
                        if (Internal.isFineLogging()) {
                            Internal.logFine(this, "thread exiting");
                        }
                        return;
                    }
                    job = this.selectJob();
                    if (job != null) break;
                    this.myLock.wait(1000L);
                    this.myLock.notify();
                }
                this.myCurrentJob = job;
            }
            this.executeJob(job);
        }
    }

    private void cancelJobs(List<SQLiteJob> jobs) {
        if (jobs != null) {
            for (SQLiteJob job : jobs) {
                job.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadStopped() {
        boolean reincarnate;
        assert (Thread.currentThread() == this.myThread) : Thread.currentThread() + " " + this.myThread;
        this.disposeConnection(this.myConnection);
        this.myConnection = null;
        List<SQLiteJob> droppedJobs = null;
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = reincarnate = !this.myStopRequested;
            if (reincarnate && !this.isReincarnationPossible()) {
                Internal.log(Level.SEVERE, this, "stopped abnormally, reincarnation is not possible for in-memory database", null);
                reincarnate = false;
                this.myStopRequested = true;
            }
            if (!reincarnate) {
                droppedJobs = this.removeJobsClearQueue();
            }
            this.myThread = null;
        }
        if (!reincarnate) {
            this.cancelJobs(droppedJobs);
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "stopped");
            }
        } else {
            this.reincarnate(this.getReincarnationTimeout());
        }
    }
}

