/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteController;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SWIGTYPE_p_intarray;
import com.almworks.sqlite4java._SQLiteManual;

public class SQLiteLongArray {
    private SQLiteController myController;
    private SWIGTYPE_p_intarray myHandle;
    private final String myName;
    private volatile boolean myDisposed;

    SQLiteLongArray(SQLiteController controller, SWIGTYPE_p_intarray handle, String name) {
        assert (controller != null);
        assert (handle != null);
        assert (name != null);
        this.myController = controller;
        this.myHandle = handle;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String toString() {
        return this.myName;
    }

    public void dispose() {
        if (this.myHandle == null) {
            return;
        }
        SQLiteController controller = this.myController;
        try {
            controller.validate();
        }
        catch (SQLiteException e) {
            Internal.recoverableError(this, "invalid dispose: " + e, true);
            return;
        }
        Internal.logFine(this, "disposing");
        controller.dispose(this);
        this.myHandle = null;
        this.myController = SQLiteController.getDisposed(this.myController);
        this.myDisposed = true;
    }

    public SQLiteLongArray bind(long[] values, int offset, int length, boolean ordered, boolean unique) throws SQLiteException {
        int rc;
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(length);
        }
        if (length > 0 && offset + length > values.length) {
            throw new ArrayIndexOutOfBoundsException(offset + length);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind[" + length + "]");
        }
        if (length == 0) {
            rc = _SQLiteManual.sqlite3_intarray_unbind(this.handle());
        } else {
            if (values == null) {
                throw new NullPointerException();
            }
            rc = _SQLiteManual.sqlite3_intarray_bind(this.handle(), values, offset, length, ordered, unique);
        }
        this.myController.throwResult(rc, "bind(array)", this);
        return this;
    }

    public SQLiteLongArray bind(long[] values, int offset, int length) throws SQLiteException {
        return this.bind(values, offset, length, false, false);
    }

    public SQLiteLongArray bind(long ... values) throws SQLiteException {
        return this.bind(values, 0, values == null ? 0 : values.length, false, false);
    }

    public SQLiteLongArray bind(long[] values, boolean ordered, boolean unique) throws SQLiteException {
        return this.bind(values, 0, values == null ? 0 : values.length, ordered, unique);
    }

    private SWIGTYPE_p_intarray handle() throws SQLiteException {
        SWIGTYPE_p_intarray handle = this.myHandle;
        if (handle == null) {
            throw new SQLiteException(-96, null);
        }
        return handle;
    }

    SWIGTYPE_p_intarray arrayHandle() {
        return this.myHandle;
    }
}

