/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DynamoDBObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = -5398424300102369986L;
    public static final TypeReference<Map<String, AttributeValue>> ITEM_TYPE = new TypeReference<Map<String, AttributeValue>>(){};
    public static final TypeReference<List<ByteBuffer>> BINARY_SET_TYPE = new TypeReference<List<ByteBuffer>>(){};
    public static final TypeReference<List<String>> STRING_SET_TYPE = new TypeReference<List<String>>(){};

    public DynamoDBObjectMapper() {
        SimpleModule module = new SimpleModule("custom", Version.unknownVersion());
        module.addSerializer(ByteBuffer.class, (JsonSerializer)new ByteBufferSerializer());
        module.addDeserializer(ByteBuffer.class, (JsonDeserializer)new ByteBufferDeserializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        super.registerModule((Module)module);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.addMixInAnnotations(AttributeDefinition.class, AttributeDefinitionMixIn.class);
        this.addMixInAnnotations(AttributeValue.class, AttributeValueMixIn.class);
        this.addMixInAnnotations(AttributeValueUpdate.class, AttributeValueUpdateMixIn.class);
        this.addMixInAnnotations(BatchGetItemRequest.class, BatchGetItemRequestMixIn.class);
        this.addMixInAnnotations(BatchGetItemResult.class, BatchGetItemResultMixIn.class);
        this.addMixInAnnotations(BatchWriteItemRequest.class, BatchWriteItemRequestMixIn.class);
        this.addMixInAnnotations(BatchWriteItemResult.class, BatchWriteItemResultMixIn.class);
        this.addMixInAnnotations(Condition.class, ConditionMixIn.class);
        this.addMixInAnnotations(ConsumedCapacity.class, ConsumedCapacityMixIn.class);
        this.addMixInAnnotations(CreateTableRequest.class, CreateTableRequestMixIn.class);
        this.addMixInAnnotations(CreateTableResult.class, CreateTableResultMixIn.class);
        this.addMixInAnnotations(DeleteItemRequest.class, DeleteItemRequestMixIn.class);
        this.addMixInAnnotations(DeleteItemResult.class, DeleteItemResultMixIn.class);
        this.addMixInAnnotations(DeleteRequest.class, DeleteRequestMixIn.class);
        this.addMixInAnnotations(DeleteTableRequest.class, DeleteTableRequestMixIn.class);
        this.addMixInAnnotations(DeleteTableResult.class, DeleteTableResultMixIn.class);
        this.addMixInAnnotations(DescribeTableRequest.class, DescribeTableRequestMixIn.class);
        this.addMixInAnnotations(DescribeTableResult.class, DescribeTableResultMixIn.class);
        this.addMixInAnnotations(ExpectedAttributeValue.class, ExpectedAttributeValueMixIn.class);
        this.addMixInAnnotations(GetItemRequest.class, GetItemRequestMixIn.class);
        this.addMixInAnnotations(GetItemResult.class, GetItemResultMixIn.class);
        this.addMixInAnnotations(GlobalSecondaryIndex.class, GlobalSecondaryIndexMixIn.class);
        this.addMixInAnnotations(GlobalSecondaryIndexDescription.class, GlobalSecondaryIndexDescriptionMixIn.class);
        this.addMixInAnnotations(GlobalSecondaryIndexUpdate.class, GlobalSecondaryIndexUpdateMixIn.class);
        this.addMixInAnnotations(ItemCollectionMetrics.class, ItemCollectionMetricsMixIn.class);
        this.addMixInAnnotations(KeysAndAttributes.class, KeysAndAttributesMixIn.class);
        this.addMixInAnnotations(KeySchemaElement.class, KeySchemaElementMixIn.class);
        this.addMixInAnnotations(ListTablesRequest.class, ListTablesRequestMixIn.class);
        this.addMixInAnnotations(ListTablesResult.class, ListTablesResultMixIn.class);
        this.addMixInAnnotations(LocalSecondaryIndexDescription.class, LocalSecondaryIndexDescriptionMixIn.class);
        this.addMixInAnnotations(LocalSecondaryIndex.class, LocalSecondaryIndexMixIn.class);
        this.addMixInAnnotations(Projection.class, ProjectionMixIn.class);
        this.addMixInAnnotations(ProvisionedThroughputDescription.class, ProvisionedThroughputDescriptionMixIn.class);
        this.addMixInAnnotations(ProvisionedThroughput.class, ProvisionedThroughputMixIn.class);
        this.addMixInAnnotations(PutItemRequest.class, PutItemRequestMixIn.class);
        this.addMixInAnnotations(PutItemResult.class, PutItemResultMixIn.class);
        this.addMixInAnnotations(PutRequest.class, PutRequestMixIn.class);
        this.addMixInAnnotations(QueryRequest.class, QueryRequestMixIn.class);
        this.addMixInAnnotations(QueryResult.class, QueryResultMixIn.class);
        this.addMixInAnnotations(ScanRequest.class, ScanRequestMixIn.class);
        this.addMixInAnnotations(ScanResult.class, ScanResultMixIn.class);
        this.addMixInAnnotations(TableDescription.class, TableDescriptionMixIn.class);
        this.addMixInAnnotations(UpdateGlobalSecondaryIndexAction.class, UpdateGlobalSecondaryIndexActionMixIn.class);
        this.addMixInAnnotations(UpdateItemRequest.class, UpdateItemRequestMixIn.class);
        this.addMixInAnnotations(UpdateItemResult.class, UpdateItemResultMixIn.class);
        this.addMixInAnnotations(UpdateTableRequest.class, UpdateTableRequestMixIn.class);
        this.addMixInAnnotations(UpdateTableResult.class, UpdateTableResultMixIn.class);
        this.addMixInAnnotations(WriteRequest.class, WriteRequestMixIn.class);
    }

    private static abstract class AttributeDefinitionMixIn {
        private AttributeDefinitionMixIn() {
        }

        @JsonProperty(value="AttributeName")
        public abstract void setAttributeName(String var1);

        @JsonProperty(value="AttributeName")
        public abstract String getAttributeName();

        @JsonProperty(value="AttributeType")
        public abstract void setAttributeType(String var1);

        @JsonProperty(value="AttributeType")
        public abstract String getAttributeType();
    }

    private static abstract class AttributeValueMixIn {
        private AttributeValueMixIn() {
        }

        @JsonProperty(value="S")
        public abstract String getS();

        @JsonProperty(value="S")
        public abstract void setS(String var1);

        @JsonProperty(value="N")
        public abstract String getN();

        @JsonProperty(value="N")
        public abstract void setN(String var1);

        @JsonProperty(value="B")
        public abstract ByteBuffer getB();

        @JsonProperty(value="B")
        public abstract void setB(ByteBuffer var1);

        @JsonProperty(value="SS")
        public abstract List<String> getSS();

        @JsonProperty(value="SS")
        public abstract void setSS(List<String> var1);

        @JsonProperty(value="NS")
        public abstract List<String> getNS();

        @JsonProperty(value="NS")
        public abstract void setNS(List<String> var1);

        @JsonProperty(value="BS")
        public abstract List<String> getBS();

        @JsonProperty(value="BS")
        public abstract void setBS(List<String> var1);
    }

    private static abstract class AttributeValueUpdateMixIn {
        private AttributeValueUpdateMixIn() {
        }

        @JsonProperty(value="Action")
        public abstract String getAction();

        @JsonProperty(value="Action")
        public abstract void setAction(String var1);

        @JsonProperty(value="Value")
        public abstract AttributeValue getValue();

        @JsonProperty(value="Value")
        public abstract void setValue(AttributeValue var1);
    }

    private static abstract class BatchGetItemRequestMixIn {
        private BatchGetItemRequestMixIn() {
        }

        @JsonProperty(value="RequestItems")
        public abstract Map<String, KeysAndAttributes> getRequestItems();

        @JsonProperty(value="RequestItems")
        public abstract void setRequestItems(Map<String, KeysAndAttributes> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);
    }

    private static abstract class BatchGetItemResultMixIn {
        private BatchGetItemResultMixIn() {
        }

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(List<ConsumedCapacity> var1);

        @JsonProperty(value="Responses")
        public abstract Map<String, List<Map<String, AttributeValue>>> getResponses();

        @JsonProperty(value="Responses")
        public abstract void setResponses(Map<String, List<Map<String, AttributeValue>>> var1);

        @JsonProperty(value="UnprocessedKeys")
        public abstract Map<String, KeysAndAttributes> getUnprocessedKeys();

        @JsonProperty(value="UnprocessedKeys")
        public abstract void setUnprocessedKeys(Map<String, KeysAndAttributes> var1);
    }

    private static abstract class BatchWriteItemRequestMixIn {
        private BatchWriteItemRequestMixIn() {
        }

        @JsonProperty(value="RequestItems")
        public abstract Map<String, List<WriteRequest>> getRequestItems();

        @JsonProperty(value="RequestItems")
        public abstract void setRequestItems(Map<String, List<WriteRequest>> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String getReturnItemCollectionMetrics();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract void setReturnItemCollectionMetrics(String var1);
    }

    private static abstract class BatchWriteItemResultMixIn {
        private BatchWriteItemResultMixIn() {
        }

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(List<ConsumedCapacity> var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract Map<String, List<ItemCollectionMetrics>> getItemCollectionMetrics();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract void setItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> var1);

        @JsonProperty(value="UnprocessedItems")
        public abstract Map<String, List<WriteRequest>> getUnprocessedItems();

        @JsonProperty(value="UnprocessedItems")
        public abstract void setUnprocessedItems(Map<String, List<WriteRequest>> var1);
    }

    private static class ByteBufferDeserializer
    extends JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ByteBuffer.wrap(jp.getBinaryValue());
        }
    }

    private static class ByteBufferSerializer
    extends JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        public void serialize(ByteBuffer value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeBinary(value.array());
        }
    }

    private static abstract class ConditionMixIn {
        private ConditionMixIn() {
        }

        @JsonProperty(value="AttributeValueList")
        public abstract List<AttributeValue> getAttributeValueList();

        @JsonProperty(value="AttributeValueList")
        public abstract void setAttributeValueList(List<AttributeValue> var1);

        @JsonProperty(value="ComparisonOperator")
        public abstract String getComparisonOperator();

        @JsonProperty(value="ComparisonOperator")
        public abstract void setComparisonOperator(String var1);
    }

    private static abstract class ConsumedCapacityMixIn {
        private ConsumedCapacityMixIn() {
        }

        @JsonProperty(value="CapacityUnits")
        public abstract Double getCapacityUnits();

        @JsonProperty(value="CapacityUnits")
        public abstract void setCapacityUnits(Double var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);
    }

    private static abstract class CreateTableRequestMixIn {
        private CreateTableRequestMixIn() {
        }

        @JsonProperty(value="AttributeDefinitions")
        public abstract void setAttributeDefinitions(List<AttributeDefinition> var1);

        @JsonProperty(value="AttributeDefinitions")
        public abstract List<AttributeDefinition> getAttributeDefinitions();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract List<LocalSecondaryIndex> getLocalSecondaryIndexes();

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract void setLocalSecondaryIndexes(List<LocalSecondaryIndex> var1);

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract List<GlobalSecondaryIndex> getGlobalSecondaryIndexes();

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract void setGlobalSecondaryIndexes(List<GlobalSecondaryIndex> var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughput var1);
    }

    private static abstract class CreateTableResultMixIn {
        private CreateTableResultMixIn() {
        }

        @JsonProperty(value="TableDescription")
        public abstract TableDescription getTableDescription();

        @JsonProperty(value="TableDescription")
        public abstract void setTableDescription(TableDescription var1);
    }

    private static class DateSerializer
    extends JsonSerializer<Date> {
        private DateSerializer() {
        }

        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(new BigDecimal((double)value.getTime() / 1000.0).setScale(3, RoundingMode.HALF_UP));
        }
    }

    private static abstract class DeleteItemRequestMixIn {
        private DeleteItemRequestMixIn() {
        }

        @JsonProperty(value="ReturnValues")
        public abstract String getReturnValues();

        @JsonProperty(value="ReturnValues")
        public abstract void setReturnValues(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String getReturnItemCollectionMetrics();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract void setReturnItemCollectionMetrics(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="Key")
        public abstract Map<String, AttributeValue> getKey();

        @JsonProperty(value="Key")
        public abstract void setKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="Expected")
        public abstract Map<String, ExpectedAttributeValue> getExpected();

        @JsonProperty(value="Expected")
        public abstract void setExpected(Map<String, ExpectedAttributeValue> var1);
    }

    private static abstract class DeleteItemResultMixIn {
        private DeleteItemResultMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, AttributeValue> getAttributes();

        @JsonProperty(value="Attributes")
        public abstract void setAttributes(Map<String, AttributeValue> var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics getItemCollectionMetrics();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract void setItemCollectionMetrics(ItemCollectionMetrics var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class DeleteRequestMixIn {
        private DeleteRequestMixIn() {
        }

        @JsonProperty(value="Key")
        public abstract Map<String, AttributeValue> getKey();

        @JsonProperty(value="Key")
        public abstract void setKey(Map<String, AttributeValue> var1);
    }

    private static abstract class DeleteTableRequestMixIn {
        private DeleteTableRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);
    }

    private static abstract class DeleteTableResultMixIn {
        private DeleteTableResultMixIn() {
        }

        @JsonProperty(value="TableDescription")
        public abstract TableDescription getTableDescription();

        @JsonProperty(value="TableDescription")
        public abstract void setTableDescription(TableDescription var1);
    }

    private static abstract class DescribeTableRequestMixIn {
        private DescribeTableRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);
    }

    private static abstract class DescribeTableResultMixIn {
        private DescribeTableResultMixIn() {
        }

        @JsonProperty(value="Table")
        public abstract TableDescription getTable();

        @JsonProperty(value="Table")
        public abstract void setTable(TableDescription var1);
    }

    private static abstract class ExpectedAttributeValueMixIn {
        private ExpectedAttributeValueMixIn() {
        }

        @JsonProperty(value="Exists")
        public abstract Boolean getExists();

        @JsonProperty(value="Exists")
        public abstract void setExists(Boolean var1);

        @JsonProperty(value="Value")
        public abstract AttributeValue getValue();

        @JsonProperty(value="Value")
        public abstract void setValue(AttributeValue var1);
    }

    private static abstract class GetItemRequestMixIn {
        private GetItemRequestMixIn() {
        }

        @JsonProperty(value="AttributesToGet")
        public abstract List<String> getAttributesToGet();

        @JsonProperty(value="AttributesToGet")
        public abstract void setAttributesToGet(List<String> var1);

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean getConsistentRead();

        @JsonProperty(value="ConsistentRead")
        public abstract void setConsistentRead(Boolean var1);

        @JsonProperty(value="Key")
        public abstract Map<String, AttributeValue> getKey();

        @JsonProperty(value="Key")
        public abstract void setKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);
    }

    private static abstract class GetItemResultMixIn {
        private GetItemResultMixIn() {
        }

        @JsonProperty(value="Item")
        public abstract Map<String, AttributeValue> getItem();

        @JsonProperty(value="Item")
        public abstract void setItem(Map<String, AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class GlobalSecondaryIndexDescriptionMixIn {
        private GlobalSecondaryIndexDescriptionMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract void setIndexName(String var1);

        @JsonProperty(value="IndexSizeBytes")
        public abstract Long getIndexSizeBytes();

        @JsonProperty(value="IndexSizeBytes")
        public abstract void setIndexSizeBytes(Long var1);

        @JsonProperty(value="ItemCount")
        public abstract Long getItemCount();

        @JsonProperty(value="ItemCount")
        public abstract void setItemCount(Long var1);

        @JsonProperty(value="IndexStatus")
        public abstract String getIndexStatus();

        @JsonProperty(value="IndexStatus")
        public abstract void setIndexStatus(String var1);

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="Projection")
        public abstract Projection getProjection();

        @JsonProperty(value="Projection")
        public abstract void setProjection(Projection var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughput var1);
    }

    private static abstract class GlobalSecondaryIndexMixIn {
        private GlobalSecondaryIndexMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract void setIndexName(String var1);

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="Projection")
        public abstract Projection getProjection();

        @JsonProperty(value="Projection")
        public abstract void setProjection(Projection var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughput var1);
    }

    private static abstract class GlobalSecondaryIndexUpdateMixIn {
        private GlobalSecondaryIndexUpdateMixIn() {
        }

        @JsonProperty(value="UpdateGlobalSecondaryIndexAction")
        public abstract UpdateGlobalSecondaryIndexAction getUpdate();

        @JsonProperty(value="UpdateGlobalSecondaryIndexAction")
        public abstract void setUpdate(UpdateGlobalSecondaryIndexAction var1);
    }

    private static abstract class ItemCollectionMetricsMixIn {
        private ItemCollectionMetricsMixIn() {
        }

        @JsonProperty(value="ItemCollectionKey")
        public abstract Map<String, AttributeValue> getItemCollectionKey();

        @JsonProperty(value="ItemCollectionKey")
        public abstract void setItemCollectionKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="SizeEstimateRangeGB")
        public abstract List<Double> getSizeEstimateRangeGB();

        @JsonProperty(value="SizeEstimateRangeGB")
        public abstract void setSizeEstimateRangeGB(List<Double> var1);
    }

    private static abstract class KeySchemaElementMixIn {
        private KeySchemaElementMixIn() {
        }

        @JsonProperty(value="AttributeName")
        public abstract String getAttributeName();

        @JsonProperty(value="AttributeName")
        public abstract void setAttributeName(String var1);

        @JsonProperty(value="KeyType")
        public abstract String getKeyType();

        @JsonProperty(value="KeyType")
        public abstract void setKeyType(String var1);
    }

    private static abstract class KeysAndAttributesMixIn {
        private KeysAndAttributesMixIn() {
        }

        @JsonProperty(value="AttributesToGet")
        public abstract List<String> getAttributesToGet();

        @JsonProperty(value="AttributesToGet")
        public abstract void setAttributesToGet(List<String> var1);

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean getConsistentRead();

        @JsonProperty(value="ConsistentRead")
        public abstract void setConsistentRead(Boolean var1);

        @JsonProperty(value="Keys")
        public abstract List<Map<String, AttributeValue>> getKeys();

        @JsonProperty(value="Keys")
        public abstract void setKeys(List<Map<String, AttributeValue>> var1);
    }

    private static abstract class ListTablesRequestMixIn {
        private ListTablesRequestMixIn() {
        }

        @JsonProperty(value="Limit")
        public abstract Integer getLimit();

        @JsonProperty(value="Limit")
        public abstract void setLimit(Integer var1);

        @JsonProperty(value="ExclusiveStartTableName")
        public abstract String getExclusiveStartTableName();

        @JsonProperty(value="ExclusiveStartTableName")
        public abstract void setExclusiveStartTableName(String var1);
    }

    private static abstract class ListTablesResultMixIn {
        private ListTablesResultMixIn() {
        }

        @JsonProperty(value="LastEvaluatedTableName")
        public abstract String getLastEvaluatedTableName();

        @JsonProperty(value="LastEvaluatedTableName")
        public abstract void setLastEvaluatedTableName(String var1);

        @JsonProperty(value="TableNames")
        public abstract List<String> getTableNames();

        @JsonProperty(value="TableNames")
        public abstract void setTableNames(List<String> var1);
    }

    private static abstract class LocalSecondaryIndexDescriptionMixIn {
        private LocalSecondaryIndexDescriptionMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract void setIndexName(String var1);

        @JsonProperty(value="IndexSizeBytes")
        public abstract Long getIndexSizeBytes();

        @JsonProperty(value="IndexSizeBytes")
        public abstract void setIndexSizeBytes(Long var1);

        @JsonProperty(value="ItemCount")
        public abstract Long getItemCount();

        @JsonProperty(value="ItemCount")
        public abstract void setItemCount(Long var1);

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="Projection")
        public abstract Projection getProjection();

        @JsonProperty(value="Projection")
        public abstract void setProjection(Projection var1);
    }

    private static abstract class LocalSecondaryIndexMixIn {
        private LocalSecondaryIndexMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract void setIndexName(String var1);

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="Projection")
        public abstract Projection getProjection();

        @JsonProperty(value="Projection")
        public abstract void setProjection(Projection var1);
    }

    private static abstract class ProjectionMixIn {
        private ProjectionMixIn() {
        }

        @JsonProperty(value="NonKeyAttributes")
        public abstract List<String> getNonKeyAttributes();

        @JsonProperty(value="NonKeyAttributes")
        public abstract void setNonKeyAttributes(List<String> var1);

        @JsonProperty(value="ProjectionType")
        public abstract String getProjectionType();

        @JsonProperty(value="ProjectionType")
        public abstract void setProjectionType(String var1);
    }

    private static abstract class ProvisionedThroughputDescriptionMixIn {
        private ProvisionedThroughputDescriptionMixIn() {
        }

        @JsonProperty(value="LastDecreaseDateTime")
        public abstract Date getLastDecreaseDateTime();

        @JsonProperty(value="LastDecreaseDateTime")
        public abstract void setLastDecreaseDateTime(Date var1);

        @JsonProperty(value="LastIncreaseDateTime")
        public abstract Date getLastIncreaseDateTime();

        @JsonProperty(value="LastIncreaseDateTime")
        public abstract void setLastIncreaseDateTime(Date var1);

        @JsonProperty(value="NumberOfDecreasesToday")
        public abstract Long getNumberOfDecreasesToday();

        @JsonProperty(value="NumberOfDecreasesToday")
        public abstract void setNumberOfDecreasesToday(Long var1);

        @JsonProperty(value="ReadCapacityUnits")
        public abstract Long getReadCapacityUnits();

        @JsonProperty(value="ReadCapacityUnits")
        public abstract void setReadCapacityUnits(Long var1);

        @JsonProperty(value="WriteCapacityUnits")
        public abstract Long getWriteCapacityUnits();

        @JsonProperty(value="WriteCapacityUnits")
        public abstract void setWriteCapacityUnits(Long var1);
    }

    private static abstract class ProvisionedThroughputMixIn {
        private ProvisionedThroughputMixIn() {
        }

        @JsonProperty(value="ReadCapacityUnits")
        public abstract Long getReadCapacityUnits();

        @JsonProperty(value="ReadCapacityUnits")
        public abstract void setReadCapacityUnits(Long var1);

        @JsonProperty(value="WriteCapacityUnits")
        public abstract Long getWriteCapacityUnits();

        @JsonProperty(value="WriteCapacityUnits")
        public abstract void setWriteCapacityUnits(Long var1);
    }

    private static abstract class PutItemRequestMixIn {
        private PutItemRequestMixIn() {
        }

        @JsonProperty(value="Expected")
        public abstract Map<String, ExpectedAttributeValue> getExpected();

        @JsonProperty(value="Expected")
        public abstract void setExpected(Map<String, ExpectedAttributeValue> var1);

        @JsonProperty(value="Item")
        public abstract Map<String, AttributeValue> getItem();

        @JsonProperty(value="Item")
        public abstract void setItem(Map<String, AttributeValue> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String getReturnItemCollectionMetrics();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract void setReturnItemCollectionMetrics(String var1);

        @JsonProperty(value="ReturnValues")
        public abstract String getReturnValues();

        @JsonProperty(value="ReturnValues")
        public abstract void setReturnValues(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);
    }

    private static abstract class PutItemResultMixIn {
        private PutItemResultMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, AttributeValue> getAttributes();

        @JsonProperty(value="Attributes")
        public abstract void setAttributes(Map<String, AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics getItemCollectionMetrics();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract void setItemCollectionMetrics(ItemCollectionMetrics var1);
    }

    private static abstract class PutRequestMixIn {
        private PutRequestMixIn() {
        }

        @JsonProperty(value="Item")
        public abstract Map<String, AttributeValue> getItem();

        @JsonProperty(value="Item")
        public abstract void setItem(Map<String, AttributeValue> var1);
    }

    private static abstract class QueryRequestMixIn {
        private QueryRequestMixIn() {
        }

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean getConsistentRead();

        @JsonProperty(value="ConsistentRead")
        public abstract void setConsistentRead(Boolean var1);

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract void setIndexName(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="ExclusiveStartKey")
        public abstract Map<String, AttributeValue> getExclusiveStartKey();

        @JsonProperty(value="ExclusiveStartKey")
        public abstract void setExclusiveStartKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="AttributesToGet")
        public abstract List<String> getAttributesToGet();

        @JsonProperty(value="AttributesToGet")
        public abstract void setAttributesToGet(List<String> var1);

        @JsonProperty(value="Limit")
        public abstract Integer getLimit();

        @JsonProperty(value="Limit")
        public abstract void setLimit(Integer var1);

        @JsonProperty(value="KeyConditions")
        public abstract Map<String, Condition> getKeyConditions();

        @JsonProperty(value="KeyConditions")
        public abstract void setKeyConditions(Map<String, Condition> var1);

        @JsonProperty(value="ScanIndexForward")
        public abstract Boolean getScanIndexForward();

        @JsonProperty(value="ScanIndexForward")
        public abstract void setScanIndexForward(Boolean var1);

        @JsonProperty(value="Select")
        public abstract String getSelect();

        @JsonProperty(value="Select")
        public abstract void setSelect(String var1);
    }

    private static abstract class QueryResultMixIn {
        private QueryResultMixIn() {
        }

        @JsonProperty(value="Count")
        public abstract Integer getCount();

        @JsonProperty(value="Count")
        public abstract void setCount(Integer var1);

        @JsonProperty(value="Items")
        public abstract List<Map<String, AttributeValue>> getItems();

        @JsonProperty(value="Items")
        public abstract void setItems(List<Map<String, AttributeValue>> var1);

        @JsonProperty(value="LastEvaluatedKey")
        public abstract Map<String, AttributeValue> getLastEvaluatedKey();

        @JsonProperty(value="LastEvaluatedKey")
        public abstract void setLastEvaluatedKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class ScanRequestMixIn {
        private ScanRequestMixIn() {
        }

        @JsonProperty(value="ScanFilter")
        public abstract Map<String, Condition> getScanFilter();

        @JsonProperty(value="ScanFilter")
        public abstract void setScanFilter(Map<String, Condition> var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="ExclusiveStartKey")
        public abstract Map<String, AttributeValue> getExclusiveStartKey();

        @JsonProperty(value="ExclusiveStartKey")
        public abstract void setExclusiveStartKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="AttributesToGet")
        public abstract List<String> getAttributesToGet();

        @JsonProperty(value="AttributesToGet")
        public abstract void setAttributesToGet(List<String> var1);

        @JsonProperty(value="Limit")
        public abstract Integer getLimit();

        @JsonProperty(value="Limit")
        public abstract void setLimit(Integer var1);

        @JsonProperty(value="TotalSegments")
        public abstract Integer getTotalSegments();

        @JsonProperty(value="TotalSegments")
        public abstract void setTotalSegments(Integer var1);

        @JsonProperty(value="Segment")
        public abstract Integer getSegment();

        @JsonProperty(value="Segment")
        public abstract void setSegment(Integer var1);

        @JsonProperty(value="Select")
        public abstract String getSelect();

        @JsonProperty(value="Select")
        public abstract void setSelect(String var1);
    }

    private static abstract class ScanResultMixIn {
        private ScanResultMixIn() {
        }

        @JsonProperty(value="Count")
        public abstract Integer getCount();

        @JsonProperty(value="Count")
        public abstract void setCount(Integer var1);

        @JsonProperty(value="Items")
        public abstract List<Map<String, AttributeValue>> getItems();

        @JsonProperty(value="Items")
        public abstract void setItems(List<Map<String, AttributeValue>> var1);

        @JsonProperty(value="LastEvaluatedKey")
        public abstract Map<String, AttributeValue> getLastEvaluatedKey();

        @JsonProperty(value="LastEvaluatedKey")
        public abstract void setLastEvaluatedKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="ScannedCount")
        public abstract Integer getScannedCount();

        @JsonProperty(value="ScannedCount")
        public abstract void setScannedCount(Integer var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class TableDescriptionMixIn {
        private TableDescriptionMixIn() {
        }

        @JsonProperty(value="AttributeDefinitions")
        public abstract List<AttributeDefinition> getAttributeDefinitions();

        @JsonProperty(value="AttributeDefinitions")
        public abstract void setAttributeDefinitions(List<AttributeDefinition> var1);

        @JsonProperty(value="CreationDateTime")
        public abstract Date getCreationDateTime();

        @JsonProperty(value="CreationDateTime")
        public abstract void setCreationDateTime(Date var1);

        @JsonProperty(value="ItemCount")
        public abstract Long getItemCount();

        @JsonProperty(value="ItemCount")
        public abstract void setItemCount(Long var1);

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> getKeySchema();

        @JsonProperty(value="KeySchema")
        public abstract void setKeySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract List<LocalSecondaryIndexDescription> getLocalSecondaryIndexes();

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract void setLocalSecondaryIndexes(List<LocalSecondaryIndexDescription> var1);

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract List<GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes();

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract void setGlobalSecondaryIndexes(List<GlobalSecondaryIndexDescription> var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughputDescription getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughputDescription var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="TableSizeBytes")
        public abstract Long getTableSizeBytes();

        @JsonProperty(value="TableSizeBytes")
        public abstract void setTableSizeBytes(Long var1);

        @JsonProperty(value="TableStatus")
        public abstract String getTableStatus();

        @JsonProperty(value="TableStatus")
        public abstract void setTableStatus(String var1);
    }

    private static abstract class UpdateGlobalSecondaryIndexActionMixIn {
        private UpdateGlobalSecondaryIndexActionMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String getIndexName();

        @JsonProperty(value="IndexName")
        public abstract String setIndexName();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughput var1);
    }

    private static abstract class UpdateItemRequestMixIn {
        private UpdateItemRequestMixIn() {
        }

        @JsonProperty(value="AttributeUpdates")
        public abstract Map<String, AttributeValueUpdate> getAttributeUpdates();

        @JsonProperty(value="AttributeUpdates")
        public abstract void setAttributeUpdates(Map<String, AttributeValueUpdate> var1);

        @JsonProperty(value="ReturnValues")
        public abstract String getReturnValues();

        @JsonProperty(value="ReturnValues")
        public abstract void setReturnValues(String var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String getReturnItemCollectionMetrics();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract void setReturnItemCollectionMetrics(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String getReturnConsumedCapacity();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract void setReturnConsumedCapacity(String var1);

        @JsonProperty(value="Key")
        public abstract Map<String, AttributeValue> getKey();

        @JsonProperty(value="Key")
        public abstract void setKey(Map<String, AttributeValue> var1);

        @JsonProperty(value="Expected")
        public abstract Map<String, ExpectedAttributeValue> getExpected();

        @JsonProperty(value="Expected")
        public abstract void setExpected(Map<String, ExpectedAttributeValue> var1);
    }

    private static abstract class UpdateItemResultMixIn {
        private UpdateItemResultMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, AttributeValue> getAttributes();

        @JsonProperty(value="Attributes")
        public abstract void setAttributes(Map<String, AttributeValue> var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics getItemCollectionMetrics();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract void setItemCollectionMetrics(ItemCollectionMetrics var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity getConsumedCapacity();

        @JsonProperty(value="ConsumedCapacity")
        public abstract void setConsumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class UpdateTableRequestMixIn {
        private UpdateTableRequestMixIn() {
        }

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput getProvisionedThroughput();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract void setProvisionedThroughput(ProvisionedThroughput var1);

        @JsonProperty(value="TableName")
        public abstract String getTableName();

        @JsonProperty(value="TableName")
        public abstract void setTableName(String var1);

        @JsonProperty(value="GlobalSecondaryIndexUpdates")
        public abstract List<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates();

        @JsonProperty(value="GlobalSecondaryIndexUpdates")
        public abstract void setGlobalSecondaryIndexUpdates(List<GlobalSecondaryIndexUpdate> var1);
    }

    private static abstract class UpdateTableResultMixIn {
        private UpdateTableResultMixIn() {
        }

        @JsonProperty(value="TableDescription")
        public abstract TableDescription getTableDescription();

        @JsonProperty(value="TableDescription")
        public abstract void setTableDescription(TableDescription var1);
    }

    private static abstract class WriteRequestMixIn {
        private WriteRequestMixIn() {
        }

        @JsonProperty(value="DeleteRequest")
        public abstract DeleteRequest getDeleteRequest();

        @JsonProperty(value="DeleteRequest")
        public abstract void setDeleteRequest(DeleteRequest var1);

        @JsonProperty(value="PutRequest")
        public abstract PutRequest getPutRequest();

        @JsonProperty(value="PutRequest")
        public abstract void setPutRequest(PutRequest var1);
    }
}

