/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteIndexElement;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TableSchemaInfo {
    private List<AttributeDefinition> attributes = null;
    private List<LocalSecondaryIndex> lsiList = null;
    private List<GlobalSecondaryIndex> gsiList = null;
    private Map<String, List<SQLiteIndexElement>> sqliteIndex = null;
    private List<SQLiteIndexElement> uniqueIndexes = null;
    private List<List<SQLiteIndexElement>> uniqueGSIIndexes = null;

    @JsonProperty(value="Attributes")
    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="Attributes")
    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(value="LSIList")
    public List<LocalSecondaryIndex> getLsiList() {
        return this.lsiList;
    }

    @JsonProperty(value="LSIList")
    public void setLsiList(List<LocalSecondaryIndex> lsiList) {
        this.lsiList = lsiList;
    }

    @JsonProperty(value="GSIList")
    public List<GlobalSecondaryIndex> getGsiList() {
        return this.gsiList;
    }

    @JsonProperty(value="GSIList")
    public void setGsiList(List<GlobalSecondaryIndex> gsiList) {
        this.gsiList = gsiList;
    }

    @JsonProperty(value="SQLiteIndex")
    public Map<String, List<SQLiteIndexElement>> getSqliteIndex() {
        return this.sqliteIndex;
    }

    @JsonProperty(value="SQLiteIndex")
    public void setSqliteIndex(Map<String, List<SQLiteIndexElement>> sqliteIndex) {
        this.sqliteIndex = sqliteIndex;
    }

    @JsonProperty(value="UniqueIndexes")
    public List<SQLiteIndexElement> getUniqueIndexes() {
        return this.uniqueIndexes;
    }

    @JsonProperty(value="UniqueIndexes")
    public void setUniqueIndexes(List<SQLiteIndexElement> uniqueIndexes) {
        this.uniqueIndexes = uniqueIndexes;
    }

    @JsonProperty(value="UniqueGSIIndexes")
    public void setUniqueGSIIndexes(List<List<SQLiteIndexElement>> uniqueGSIIndexes) {
        this.uniqueGSIIndexes = uniqueGSIIndexes;
    }

    @JsonProperty(value="UniqueGSIIndexes")
    public List<List<SQLiteIndexElement>> getUniqueGSIIndexes() {
        return this.uniqueGSIIndexes;
    }

    public TableSchemaInfo() {
    }

    @JsonIgnore
    public TableSchemaInfo(AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef, List<AttributeDefinition> attributes, List<LocalSecondaryIndex> lsiList, List<GlobalSecondaryIndex> gsiList) {
        this.attributes = attributes;
        this.lsiList = lsiList;
        this.gsiList = gsiList;
        this.uniqueIndexes = new ArrayList<SQLiteIndexElement>();
        this.sqliteIndex = new HashMap<String, List<SQLiteIndexElement>>();
        ArrayList<SQLiteIndexElement> primaryIndexes = new ArrayList<SQLiteIndexElement>();
        SQLiteIndexElement hashKeyIndex = new SQLiteIndexElement(KeyType.HASH, hashKeyDef, "hashKey");
        primaryIndexes.add(hashKeyIndex);
        this.uniqueIndexes.add(hashKeyIndex);
        if (rangeKeyDef != null) {
            SQLiteIndexElement rangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, rangeKeyDef, "rangeKey");
            primaryIndexes.add(rangeKeyIndex);
            this.uniqueIndexes.add(rangeKeyIndex);
        }
        this.sqliteIndex.put("", primaryIndexes);
        HashMap<String, AttributeDefinition> nameToDefinition = null;
        if (lsiList != null || gsiList != null) {
            nameToDefinition = new HashMap<String, AttributeDefinition>();
            for (AttributeDefinition attributeDefinition : attributes) {
                nameToDefinition.put(attributeDefinition.getAttributeName(), attributeDefinition);
            }
        }
        HashMap<String, String> sqliteColumnName = null;
        int count = 0;
        if (lsiList != null) {
            sqliteColumnName = new HashMap<String, String>();
            sqliteColumnName.put(rangeKeyDef.getAttributeName(), "rangeKey");
            for (LocalSecondaryIndex lsi : lsiList) {
                boolean isNewIndex = false;
                ArrayList<SQLiteIndexElement> lsiIndexes = new ArrayList<SQLiteIndexElement>();
                String lsiIndexName = lsi.getIndexName();
                AttributeDefinition lsiRangeKeyDef = (AttributeDefinition)nameToDefinition.get(((KeySchemaElement)lsi.getKeySchema().get(1)).getAttributeName());
                String columnName = (String)sqliteColumnName.get(lsiRangeKeyDef.getAttributeName());
                if (columnName == null) {
                    columnName = "indexKey_" + count;
                    ++count;
                    isNewIndex = true;
                }
                lsiIndexes.add(hashKeyIndex);
                SQLiteIndexElement lsiRangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, lsiRangeKeyDef, columnName);
                lsiIndexes.add(lsiRangeKeyIndex);
                if (isNewIndex) {
                    this.uniqueIndexes.add(lsiRangeKeyIndex);
                }
                sqliteColumnName.put(lsiRangeKeyDef.getAttributeName(), columnName);
                this.sqliteIndex.put(lsiIndexName, lsiIndexes);
            }
        }
        if (gsiList != null) {
            this.uniqueGSIIndexes = new ArrayList<List<SQLiteIndexElement>>();
            HashMap<String, String> gsiSqliteColumnName = new HashMap<String, String>();
            gsiSqliteColumnName.put(hashKeyDef.getAttributeName(), "hashKey");
            if (sqliteColumnName != null) {
                gsiSqliteColumnName.putAll(sqliteColumnName);
            }
            if (rangeKeyDef != null) {
                gsiSqliteColumnName.put(rangeKeyDef.getAttributeName(), "rangeKey");
            }
            HashMap gsiHashToRangeMap = new HashMap();
            for (GlobalSecondaryIndex gsi : gsiList) {
                boolean isNewIndex = true;
                ArrayList<SQLiteIndexElement> gsiIndexes = new ArrayList<SQLiteIndexElement>();
                String gsiIndexName = gsi.getIndexName();
                AttributeDefinition gsiHashKeyDef = (AttributeDefinition)nameToDefinition.get(((KeySchemaElement)gsi.getKeySchema().get(0)).getAttributeName());
                AttributeDefinition gsiRangeKeyDef = null;
                if (gsi.getKeySchema().size() == 2) {
                    gsiRangeKeyDef = (AttributeDefinition)nameToDefinition.get(((KeySchemaElement)gsi.getKeySchema().get(1)).getAttributeName());
                }
                if (rangeKeyDef == null && gsiRangeKeyDef == null && gsiHashKeyDef.getAttributeName().equals(hashKeyDef.getAttributeName())) {
                    isNewIndex = false;
                } else if (lsiList != null && gsiRangeKeyDef != null && gsiHashKeyDef.getAttributeName().equals(hashKeyDef.getAttributeName()) && sqliteColumnName.containsKey(gsiRangeKeyDef.getAttributeName())) {
                    isNewIndex = false;
                } else if (gsiHashToRangeMap.containsKey(gsiHashKeyDef.getAttributeName())) {
                    if (gsiRangeKeyDef == null) {
                        if (((Set)gsiHashToRangeMap.get(gsiHashKeyDef.getAttributeName())).contains(null)) {
                            isNewIndex = false;
                        }
                    } else if (((Set)gsiHashToRangeMap.get(gsiHashKeyDef.getAttributeName())).contains(gsiRangeKeyDef.getAttributeName())) {
                        isNewIndex = false;
                    }
                }
                String hashColName = (String)gsiSqliteColumnName.get(gsiHashKeyDef.getAttributeName());
                String rangeColName = null;
                if (gsiRangeKeyDef != null) {
                    rangeColName = (String)gsiSqliteColumnName.get(gsiRangeKeyDef.getAttributeName());
                }
                if (hashColName == null) {
                    hashColName = "indexKey_" + count;
                    ++count;
                    gsiSqliteColumnName.put(gsiHashKeyDef.getAttributeName(), hashColName);
                }
                if (gsiRangeKeyDef != null && rangeColName == null) {
                    rangeColName = "indexKey_" + count;
                    ++count;
                    gsiSqliteColumnName.put(gsiRangeKeyDef.getAttributeName(), rangeColName);
                }
                SQLiteIndexElement gsiHashKeyIndex = new SQLiteIndexElement(KeyType.HASH, gsiHashKeyDef, hashColName);
                gsiIndexes.add(gsiHashKeyIndex);
                if (gsiRangeKeyDef != null) {
                    SQLiteIndexElement gsiRangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, gsiRangeKeyDef, rangeColName);
                    gsiIndexes.add(gsiRangeKeyIndex);
                }
                if (isNewIndex) {
                    this.uniqueGSIIndexes.add(gsiIndexes);
                    if (gsiHashToRangeMap.containsKey(gsiHashKeyDef.getAttributeName())) {
                        if (gsiRangeKeyDef == null) {
                            ((Set)gsiHashToRangeMap.get(gsiHashKeyDef.getAttributeName())).add(null);
                        } else {
                            ((Set)gsiHashToRangeMap.get(gsiHashKeyDef.getAttributeName())).add(gsiRangeKeyDef.getAttributeName());
                        }
                    } else {
                        HashSet<String> rangeKeys = new HashSet<String>();
                        if (gsiRangeKeyDef == null) {
                            rangeKeys.add(null);
                        } else {
                            rangeKeys.add(gsiRangeKeyDef.getAttributeName());
                        }
                        gsiHashToRangeMap.put(gsiHashKeyDef.getAttributeName(), rangeKeys);
                    }
                }
                gsiSqliteColumnName.put(gsiHashKeyDef.getAttributeName(), hashColName);
                if (gsiRangeKeyDef != null) {
                    gsiSqliteColumnName.put(gsiRangeKeyDef.getAttributeName(), rangeColName);
                }
                this.sqliteIndex.put(gsiIndexName, gsiIndexes);
            }
        }
    }

    @JsonIgnore
    public SQLiteIndexElement getHashKeyIndex() {
        return this.sqliteIndex.get("").get(0);
    }

    @JsonIgnore
    public AttributeDefinition getHashKeyDefinition() {
        return this.getHashKeyIndex().getDynamoDBAttribute();
    }

    @JsonIgnore
    public SQLiteIndexElement getRangeKeyIndex() {
        if (this.sqliteIndex.get("").size() == 2) {
            return this.sqliteIndex.get("").get(1);
        }
        return null;
    }

    @JsonIgnore
    public AttributeDefinition getRangeKeyDefinition() {
        SQLiteIndexElement index = this.getRangeKeyIndex();
        if (index != null) {
            return index.getDynamoDBAttribute();
        }
        return null;
    }

    @JsonIgnore
    public SQLiteIndexElement getLSIRangeIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null) {
            return null;
        }
        return indexes.get(1);
    }

    @JsonIgnore
    public SQLiteIndexElement getGSIHashIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null) {
            return null;
        }
        return indexes.get(0);
    }

    @JsonIgnore
    public SQLiteIndexElement getGSIRangeIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null || indexes.size() < 2) {
            return null;
        }
        return indexes.get(1);
    }

    public String toString() {
        String ret = "";
        for (String k : this.sqliteIndex.keySet()) {
            ret = String.valueOf(ret) + k + "\n";
            for (SQLiteIndexElement e : this.sqliteIndex.get(k)) {
                ret = String.valueOf(ret) + "\t" + e.toString() + "\n";
            }
        }
        return ret;
    }
}

