/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableInfo {
    private String tableName;
    private AttributeDefinition hashKey;
    private AttributeDefinition rangeKey;
    private List<AttributeDefinition> allAttributes;
    private Map<String, AttributeDefinition> lsiKeys;
    private Map<String, AttributeDefinition> gsiHashKeys;
    private Map<String, AttributeDefinition> gsiRangeKeys;
    private ProvisionedThroughput throughput;
    private Map<String, LocalSecondaryIndex> lsiMap;
    private Map<String, GlobalSecondaryIndex> gsiMap;
    private long creationDateTime;
    private Long lastDecreaseDateTime;
    private Long lastIncreaseDateTime;
    private long numberOfDecreasesToday;

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndex> gsiIndexes, ProvisionedThroughput throughput) {
        String curIndexName;
        this.tableName = tableName;
        this.hashKey = hashKey;
        this.rangeKey = rangeKey;
        this.allAttributes = allAttributes;
        this.lsiMap = new HashMap<String, LocalSecondaryIndex>();
        this.lsiKeys = new HashMap<String, AttributeDefinition>();
        if (lsiIndexes != null) {
            for (LocalSecondaryIndex localSecondaryIndex : lsiIndexes) {
                curIndexName = localSecondaryIndex.getIndexName();
                KeySchemaElement curIndexRangeElement = (KeySchemaElement)localSecondaryIndex.getKeySchema().get(1);
                this.lsiKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexRangeElement, allAttributes));
                this.lsiMap.put(curIndexName, localSecondaryIndex);
            }
        }
        this.gsiMap = new HashMap<String, GlobalSecondaryIndex>();
        this.gsiHashKeys = new HashMap<String, AttributeDefinition>();
        this.gsiRangeKeys = new HashMap<String, AttributeDefinition>();
        if (gsiIndexes != null) {
            for (GlobalSecondaryIndex globalSecondaryIndex : gsiIndexes) {
                curIndexName = globalSecondaryIndex.getIndexName();
                KeySchemaElement curIndexHashElement = (KeySchemaElement)globalSecondaryIndex.getKeySchema().get(0);
                this.gsiHashKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexHashElement, allAttributes));
                if (globalSecondaryIndex.getKeySchema().size() == 2) {
                    KeySchemaElement curIndexRangeElement = (KeySchemaElement)globalSecondaryIndex.getKeySchema().get(1);
                    this.gsiRangeKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexRangeElement, allAttributes));
                }
                this.gsiMap.put(curIndexName, globalSecondaryIndex);
            }
        }
        this.throughput = throughput;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndex> gsiIndexes, ProvisionedThroughput throughput, long creationDateTime) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexes, throughput);
        this.creationDateTime = creationDateTime;
        this.lastDecreaseDateTime = null;
        this.lastIncreaseDateTime = null;
        this.numberOfDecreasesToday = 0L;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndex> gsiIndexes, ProvisionedThroughput throughput, long creationDateTime, Long lastDecreaseDateTime, Long lastIncreaseDateTime, long numberOfDecreasesToday) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexes, throughput);
        this.creationDateTime = creationDateTime;
        this.lastDecreaseDateTime = lastDecreaseDateTime;
        this.lastIncreaseDateTime = lastIncreaseDateTime;
        this.numberOfDecreasesToday = numberOfDecreasesToday;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ProvisionedThroughput getThroughput() {
        return this.throughput;
    }

    public boolean hasRangeKey() {
        return this.rangeKey != null;
    }

    public AttributeDefinition getHashKey() {
        return this.hashKey;
    }

    public AttributeDefinition getRangeKey() {
        return this.rangeKey;
    }

    public AttributeDefinition getLSIRangeKey(String indexName) {
        return this.lsiKeys.get(indexName);
    }

    public AttributeDefinition getGSIHashKey(String indexName) {
        return this.gsiHashKeys.get(indexName);
    }

    public AttributeDefinition getGSIRangeKey(String indexName) {
        return this.gsiRangeKeys.get(indexName);
    }

    public boolean hasIndex(String indexName) {
        return this.lsiKeys.containsKey(indexName) || this.gsiHashKeys.containsKey(indexName);
    }

    public long getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<String> getLSINames() {
        return new ArrayList<String>(this.lsiMap.keySet());
    }

    public List<String> getGSINames() {
        return new ArrayList<String>(this.gsiMap.keySet());
    }

    public void setCreationDateTime(long curTime) {
        this.creationDateTime = curTime;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.allAttributes;
    }

    public List<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(this.hashKey.getAttributeName()).withKeyType(KeyType.HASH));
        if (this.rangeKey != null) {
            keySchema.add(new KeySchemaElement().withAttributeName(this.rangeKey.getAttributeName()).withKeyType(KeyType.RANGE));
        }
        return keySchema;
    }

    public ProvisionedThroughputDescription getThroughputDescription() {
        return new ProvisionedThroughputDescription().withReadCapacityUnits(this.throughput.getReadCapacityUnits()).withWriteCapacityUnits(this.throughput.getWriteCapacityUnits()).withLastDecreaseDateTime(this.lastDecreaseDateTime == null ? null : new Date(this.lastDecreaseDateTime)).withLastIncreaseDateTime(this.lastIncreaseDateTime == null ? null : new Date(this.lastIncreaseDateTime)).withNumberOfDecreasesToday(Long.valueOf(this.numberOfDecreasesToday));
    }

    public ProvisionedThroughputDescription getGSIThroughputDescription(String gsi, Long lastDecreaseDateTime, Long lastIncreaseDateTime, Long numberOfDecreasesToday) {
        return new ProvisionedThroughputDescription().withReadCapacityUnits(this.gsiMap.get(gsi).getProvisionedThroughput().getReadCapacityUnits()).withWriteCapacityUnits(this.gsiMap.get(gsi).getProvisionedThroughput().getWriteCapacityUnits()).withLastDecreaseDateTime(lastDecreaseDateTime == null ? null : new Date(lastDecreaseDateTime)).withLastIncreaseDateTime(lastIncreaseDateTime == null ? null : new Date(lastIncreaseDateTime)).withNumberOfDecreasesToday(numberOfDecreasesToday);
    }

    public List<LocalSecondaryIndexDescription> getLSIDescriptions() {
        if (this.lsiMap.size() == 0) {
            return null;
        }
        ArrayList<LocalSecondaryIndexDescription> indexDescList = new ArrayList<LocalSecondaryIndexDescription>();
        for (Map.Entry<String, LocalSecondaryIndex> entry : this.lsiMap.entrySet()) {
            LocalSecondaryIndex index = entry.getValue();
            indexDescList.add(new LocalSecondaryIndexDescription().withIndexName(index.getIndexName()).withKeySchema((Collection)index.getKeySchema()).withProjection(index.getProjection()).withIndexSizeBytes(Long.valueOf(0L)).withItemCount(Long.valueOf(0L)));
        }
        return indexDescList;
    }

    public List<GlobalSecondaryIndexDescription> getGSIDescriptions() {
        if (this.gsiMap.size() == 0) {
            return null;
        }
        ArrayList<GlobalSecondaryIndexDescription> indexDescList = new ArrayList<GlobalSecondaryIndexDescription>();
        for (Map.Entry<String, GlobalSecondaryIndex> entry : this.gsiMap.entrySet()) {
            GlobalSecondaryIndex index = entry.getValue();
            indexDescList.add(new GlobalSecondaryIndexDescription().withIndexName(index.getIndexName()).withKeySchema((Collection)index.getKeySchema()).withProjection(index.getProjection()).withIndexSizeBytes(Long.valueOf(0L)).withItemCount(Long.valueOf(0L)).withProvisionedThroughput(this.getGSIThroughputDescription(index.getIndexName(), null, null, null)).withIndexStatus(IndexStatus.ACTIVE));
        }
        return indexDescList;
    }

    public Projection getProjection(String indexName) {
        if (this.lsiMap.containsKey(indexName)) {
            return this.lsiMap.get(indexName).getProjection();
        }
        return this.gsiMap.get(indexName).getProjection();
    }

    public AttributeDefinition getLSIRangeKeyWithAttributeName(String attrName) {
        for (Map.Entry<String, AttributeDefinition> entry : this.lsiKeys.entrySet()) {
            AttributeDefinition curDef = entry.getValue();
            if (!curDef.getAttributeName().equals(attrName)) continue;
            return curDef;
        }
        return null;
    }

    public AttributeDefinition getGSIRangeKeyWithAttributeName(String attrName) {
        for (Map.Entry<String, AttributeDefinition> entry : this.gsiRangeKeys.entrySet()) {
            AttributeDefinition curDef = entry.getValue();
            if (!curDef.getAttributeName().equals(attrName)) continue;
            return curDef;
        }
        return null;
    }

    public AttributeDefinition getGSIHashKeyWithAttributeName(String attrName) {
        for (Map.Entry<String, AttributeDefinition> entry : this.gsiHashKeys.entrySet()) {
            AttributeDefinition curDef = entry.getValue();
            if (!curDef.getAttributeName().equals(attrName)) continue;
            return curDef;
        }
        return null;
    }

    public List<LocalSecondaryIndex> getLSIIndexes() {
        if (this.lsiMap.values().isEmpty()) {
            return null;
        }
        return new ArrayList<LocalSecondaryIndex>(this.lsiMap.values());
    }

    public List<GlobalSecondaryIndex> getGSIIndexes() {
        if (this.gsiMap.values().isEmpty()) {
            return null;
        }
        return new ArrayList<GlobalSecondaryIndex>(this.gsiMap.values());
    }

    public boolean isLSIIndex(String indexName) {
        return this.lsiMap.keySet().contains(indexName);
    }

    public boolean isGSIIndex(String indexName) {
        return this.gsiMap.keySet().contains(indexName);
    }

    public GlobalSecondaryIndex getGSIWithName(String gsiName) {
        return this.gsiMap.get(gsiName);
    }
}

