/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.access.DDBType;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionType;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;

public enum LocalDBComparisonOperator {
    EQ{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            return this.compareFilterHelper(value, expectedVal, type) == 0;
        }
    }
    ,
    NE{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            return !EQ.evaluate(attributeValueList, value);
        }
    }
    ,
    IN{

        @Override
        public boolean isValidForQuery() {
            return false;
        }

        @Override
        public void isValidAttributeList(List<AttributeValue> attributeValueList) {
            if (attributeValueList == null || attributeValueList.size() < 1) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NO_DATA.getMessage());
            }
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(attributeValueList.get(0));
            if (type == DDBType.BS || type == DDBType.SS || type == DDBType.NS) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_SETS.getMessage());
            }
            int i = 1;
            while (i < attributeValueList.size()) {
                DDBType curType = LocalDBUtils.getDataTypeOfAttributeValue(attributeValueList.get(i));
                if (curType == DDBType.BS || curType == DDBType.SS || curType == DDBType.NS) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_SETS.getMessage());
                }
                if (curType != type) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_IN_DATATYPES.getMessage());
                }
                ++i;
            }
        }

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            if (value == null) {
                return false;
            }
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(value);
            try {
                LocalDBUtils.validateConsistentTypes(value, attributeValueList.get(0));
            }
            catch (AmazonServiceException ase) {
                if (ase.getMessage().equals(LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage())) {
                    return false;
                }
                throw ase;
            }
            for (AttributeValue attrVal : attributeValueList) {
                if (this.compareFilterHelper(attrVal, value, type) != 0) continue;
                return true;
            }
            return false;
        }
    }
    ,
    LE{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            int compareResult = this.compareFilterHelper(value, expectedVal, type);
            return compareResult <= 0;
        }

        @Override
        public boolean evaluateExclusive(List<AttributeValue> attributeValueList, AttributeValue value, boolean asc) {
            if (asc) {
                DDBType type;
                AttributeValue expectedVal = attributeValueList.get(0);
                int compareResult = this.compareFilterHelper(value, expectedVal, type = LocalDBUtils.validateConsistentTypes(value, expectedVal));
                return compareResult < 0;
            }
            return this.evaluate(attributeValueList, value);
        }
    }
    ,
    LT{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            int compareResult = this.compareFilterHelper(value, expectedVal, type);
            return compareResult < 0;
        }
    }
    ,
    GE{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            int compareResult = this.compareFilterHelper(value, expectedVal, type);
            return compareResult >= 0;
        }

        @Override
        public boolean evaluateExclusive(List<AttributeValue> attributeValueList, AttributeValue value, boolean asc) {
            DDBType type;
            if (asc) {
                return this.evaluate(attributeValueList, value);
            }
            AttributeValue expectedVal = attributeValueList.get(0);
            int compareResult = this.compareFilterHelper(value, expectedVal, type = LocalDBUtils.validateConsistentTypes(value, expectedVal));
            return compareResult > 0;
        }
    }
    ,
    GT{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            int compareResult = this.compareFilterHelper(value, expectedVal, type);
            return compareResult > 0;
        }
    }
    ,
    BETWEEN{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            return GE.evaluate(attributeValueList, value) && LE.evaluate(attributeValueList.subList(1, 2), value);
        }

        @Override
        public boolean evaluateExclusive(List<AttributeValue> attributeValueList, AttributeValue value, boolean asc) {
            if (asc) {
                return GE.evaluate(attributeValueList, value) && LT.evaluate(attributeValueList.subList(1, 2), value);
            }
            return GT.evaluate(attributeValueList, value) && LE.evaluate(attributeValueList.subList(1, 2), value);
        }

        @Override
        public void isValidAttributeList(List<AttributeValue> attributeValueList) {
            if (attributeValueList == null || attributeValueList.size() == 0) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NO_DATA.getMessage());
            }
            if (attributeValueList.size() != 2) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_BETWEEN.getMessage());
            }
            DDBType typeLowerPivot = LocalDBUtils.getDataTypeOfAttributeValue(attributeValueList.get(0));
            DDBType typeUpperPivot = LocalDBUtils.getDataTypeOfAttributeValue(attributeValueList.get(1));
            if (typeLowerPivot == DDBType.NS || typeLowerPivot == DDBType.SS || typeLowerPivot == DDBType.BS || typeUpperPivot == DDBType.NS || typeUpperPivot == DDBType.SS || typeUpperPivot == DDBType.BS) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_SETS.getMessage());
            }
            if (typeLowerPivot != typeUpperPivot) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
            }
            if (this.compareFilterHelper(attributeValueList.get(0), attributeValueList.get(1), typeUpperPivot) > 0) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_BETWEEN_PIVOTS.getMessage());
            }
        }
    }
    ,
    NOT_NULL{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            return value != null;
        }

        @Override
        public boolean isValidForQuery() {
            return false;
        }

        @Override
        public void isValidAttributeList(List<AttributeValue> attributeValueList) {
            if (attributeValueList != null && !attributeValueList.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NULL.getMessage());
            }
        }
    }
    ,
    NULL{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            return value == null;
        }

        @Override
        public boolean isValidForQuery() {
            return false;
        }

        @Override
        public void isValidAttributeList(List<AttributeValue> attributeValueList) {
            if (attributeValueList != null && !attributeValueList.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NULL.getMessage());
            }
        }
    }
    ,
    CONTAINS{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(expectedVal);
            return this.containsFilterHelper(value, expectedVal, type);
        }

        @Override
        public boolean isValidForQuery() {
            return false;
        }
    }
    ,
    NOT_CONTAINS{

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            if (value == null) {
                return false;
            }
            return !CONTAINS.evaluate(attributeValueList, value);
        }

        @Override
        public boolean isValidForQuery() {
            return false;
        }
    }
    ,
    BEGINS_WITH{

        @Override
        public void isValidAttributeList(List<AttributeValue> attributeValueList) {
            if (attributeValueList == null || attributeValueList.size() < 1) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NO_DATA.getMessage());
            }
            if (attributeValueList.size() > 1) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NOT_BETWEEN_IN.getMessage());
            }
            AttributeValue value = attributeValueList.get(0);
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(value);
            if (type == DDBType.N || type.isSet()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_DATATYPE_BEGINS.getMessage());
            }
        }

        @Override
        public boolean evaluate(List<AttributeValue> attributeValueList, AttributeValue value) {
            AttributeValue expectedVal = attributeValueList.get(0);
            DDBType type = this.checkType(expectedVal, value);
            if (type == null) {
                return false;
            }
            switch (type) {
                case S: {
                    return value.getS().startsWith(expectedVal.getS());
                }
                case B: {
                    byte[] valueBuf = value.getB().array();
                    byte[] comparisonBuf = expectedVal.getB().array();
                    if (comparisonBuf.length > valueBuf.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < comparisonBuf.length) {
                        if (valueBuf[i] != comparisonBuf[i]) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
            return false;
        }
    };


    private LocalDBComparisonOperator() {
    }

    public void isValidAttributeList(List<AttributeValue> attributeValueList) {
        if (attributeValueList == null || attributeValueList.size() < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NO_DATA.getMessage());
        }
        if (attributeValueList.size() > 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_NOT_BETWEEN_IN.getMessage());
        }
        for (AttributeValue value : attributeValueList) {
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(value);
            if (type.isSet()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON_SETS.getMessage());
            }
            if (type != DDBType.N) continue;
            LocalDBUtils.validateNumericValue(new String(value.getN()));
        }
    }

    public boolean isValidForQuery() {
        return true;
    }

    public abstract boolean evaluate(List<AttributeValue> var1, AttributeValue var2);

    public boolean evaluateExclusive(List<AttributeValue> attributeValueList, AttributeValue value, boolean asc) {
        return this.evaluate(attributeValueList, value);
    }

    public static LocalDBComparisonOperator fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        if (ComparisonOperator.EQ.toString().equals(value)) {
            return EQ;
        }
        if (ComparisonOperator.NE.toString().equals(value)) {
            return NE;
        }
        if (ComparisonOperator.IN.toString().equals(value)) {
            return IN;
        }
        if (ComparisonOperator.LE.toString().equals(value)) {
            return LE;
        }
        if (ComparisonOperator.LT.toString().equals(value)) {
            return LT;
        }
        if (ComparisonOperator.GE.toString().equals(value)) {
            return GE;
        }
        if (ComparisonOperator.GT.toString().equals(value)) {
            return GT;
        }
        if (ComparisonOperator.BETWEEN.toString().equals(value)) {
            return BETWEEN;
        }
        if (ComparisonOperator.NOT_NULL.toString().equals(value)) {
            return NOT_NULL;
        }
        if (ComparisonOperator.NULL.toString().equals(value)) {
            return NULL;
        }
        if (ComparisonOperator.CONTAINS.toString().equals(value)) {
            return CONTAINS;
        }
        if (ComparisonOperator.NOT_CONTAINS.toString().equals(value)) {
            return NOT_CONTAINS;
        }
        if (ComparisonOperator.BEGINS_WITH.toString().equals(value)) {
            return BEGINS_WITH;
        }
        throw new IllegalArgumentException();
    }

    public static LocalDBComparisonOperator fromValue(ComparisonOperator op) {
        return LocalDBComparisonOperator.fromValue(op.toString());
    }

    protected DDBType checkType(AttributeValue expectedValue, AttributeValue value) {
        DDBType type;
        block3: {
            type = null;
            if (value != null) {
                try {
                    type = LocalDBUtils.validateConsistentTypes(value, expectedValue);
                }
                catch (AmazonServiceException ase) {
                    if (ase.getMessage().equals(LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage())) break block3;
                    throw ase;
                }
            }
        }
        return type;
    }

    protected int compareFilterHelper(AttributeValue actualVal, AttributeValue expectedVal, DDBType type) {
        switch (type) {
            case N: {
                return new BigDecimal(actualVal.getN()).compareTo(new BigDecimal(expectedVal.getN()));
            }
            case S: {
                return actualVal.getS().compareTo(expectedVal.getS());
            }
            case B: {
                return actualVal.getB().compareTo(expectedVal.getB());
            }
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return 0;
    }

    protected boolean containsFilterHelper(AttributeValue actualVal, AttributeValue expectedVal, DDBType type) {
        if (actualVal == null) {
            return false;
        }
        boolean compares = false;
        switch (type) {
            case N: {
                if (actualVal.getNS() == null) {
                    return false;
                }
                for (String numString : actualVal.getNS()) {
                    compares |= new BigDecimal(numString).compareTo(new BigDecimal(expectedVal.getN())) == 0;
                }
                return compares;
            }
            case S: {
                if (actualVal.getS() != null) {
                    return actualVal.getS().contains(expectedVal.getS());
                }
                if (actualVal.getSS() == null) {
                    return false;
                }
                for (String strString : actualVal.getSS()) {
                    compares |= strString.compareTo(expectedVal.getS()) == 0;
                }
                return compares;
            }
            case B: {
                if (actualVal.getB() != null) {
                    return new String(actualVal.getB().array(), LocalDBUtils.UTF8).contains(new String(expectedVal.getB().array(), LocalDBUtils.UTF8));
                }
                if (actualVal.getBS() == null) {
                    return false;
                }
                for (ByteBuffer byteBuf : actualVal.getBS()) {
                    compares |= byteBuf.compareTo(expectedVal.getB()) == 0;
                }
                return compares;
            }
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return false;
    }

    /* synthetic */ LocalDBComparisonOperator(String string, int n, LocalDBComparisonOperator localDBComparisonOperator) {
        this();
    }
}

