/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJobFlowStepsRequestMarshaller
implements Marshaller<Request<AddJobFlowStepsRequest>, AddJobFlowStepsRequest> {
    @Override
    public Request<AddJobFlowStepsRequest> marshall(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        if (addJobFlowStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddJobFlowStepsRequest> request = new DefaultRequest<AddJobFlowStepsRequest>(addJobFlowStepsRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.AddJobFlowSteps";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag stepsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addJobFlowStepsRequest.getJobFlowId() != null) {
                jsonWriter.key("JobFlowId").value(addJobFlowStepsRequest.getJobFlowId());
            }
            if (!((stepsList = (ListWithAutoConstructFlag)addJobFlowStepsRequest.getSteps()) == null || stepsList.isAutoConstruct() && stepsList.isEmpty())) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (StepConfig stepsListValue : stepsList) {
                    HadoopJarStepConfig hadoopJarStep;
                    if (stepsListValue == null) continue;
                    jsonWriter.object();
                    if (stepsListValue.getName() != null) {
                        jsonWriter.key("Name").value(stepsListValue.getName());
                    }
                    if (stepsListValue.getActionOnFailure() != null) {
                        jsonWriter.key("ActionOnFailure").value(stepsListValue.getActionOnFailure());
                    }
                    if ((hadoopJarStep = stepsListValue.getHadoopJarStep()) != null) {
                        ListWithAutoConstructFlag argsList;
                        jsonWriter.key("HadoopJarStep");
                        jsonWriter.object();
                        ListWithAutoConstructFlag propertiesList = (ListWithAutoConstructFlag)hadoopJarStep.getProperties();
                        if (!(propertiesList == null || propertiesList.isAutoConstruct() && propertiesList.isEmpty())) {
                            jsonWriter.key("Properties");
                            jsonWriter.array();
                            for (KeyValue propertiesListValue : propertiesList) {
                                if (propertiesListValue == null) continue;
                                jsonWriter.object();
                                if (propertiesListValue.getKey() != null) {
                                    jsonWriter.key("Key").value(propertiesListValue.getKey());
                                }
                                if (propertiesListValue.getValue() != null) {
                                    jsonWriter.key("Value").value(propertiesListValue.getValue());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if (hadoopJarStep.getJar() != null) {
                            jsonWriter.key("Jar").value(hadoopJarStep.getJar());
                        }
                        if (hadoopJarStep.getMainClass() != null) {
                            jsonWriter.key("MainClass").value(hadoopJarStep.getMainClass());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)hadoopJarStep.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            for (String argsListValue : argsList) {
                                if (argsListValue == null) continue;
                                jsonWriter.value(argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

