/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseAddressRequestMarshaller
implements Marshaller<Request<ReleaseAddressRequest>, ReleaseAddressRequest> {
    @Override
    public Request<ReleaseAddressRequest> marshall(ReleaseAddressRequest releaseAddressRequest) {
        if (releaseAddressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReleaseAddressRequest> request = new DefaultRequest<ReleaseAddressRequest>(releaseAddressRequest, "AmazonEC2");
        request.addParameter("Action", "ReleaseAddress");
        request.addParameter("Version", "2013-10-15");
        if (releaseAddressRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString(releaseAddressRequest.getPublicIp()));
        }
        if (releaseAddressRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString(releaseAddressRequest.getAllocationId()));
        }
        return request;
    }
}

