/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ExportToS3Task;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToS3TaskStaxUnmarshaller
implements Unmarshaller<ExportToS3Task, StaxUnmarshallerContext> {
    private static ExportToS3TaskStaxUnmarshaller instance;

    @Override
    public ExportToS3Task unmarshall(StaxUnmarshallerContext context) throws Exception {
        ExportToS3Task exportToS3Task = new ExportToS3Task();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return exportToS3Task;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("diskImageFormat", targetDepth)) {
                    exportToS3Task.setDiskImageFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("containerFormat", targetDepth)) {
                    exportToS3Task.setContainerFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("s3Bucket", targetDepth)) {
                    exportToS3Task.setS3Bucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("s3Key", targetDepth)) continue;
                exportToS3Task.setS3Key(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return exportToS3Task;
    }

    public static ExportToS3TaskStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExportToS3TaskStaxUnmarshaller();
        }
        return instance;
    }
}

