/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.ByteThroughputProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.ServiceLatencyProvider;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.metrics.ServiceMetricType;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.metrics.internal.cloudwatch.spi.Dimensions;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ServiceMetricCollectorSupport
extends ServiceMetricCollector {
    static final double NANO_PER_SEC = TimeUnit.SECONDS.toNanos(1L);
    protected static final Log log = LogFactory.getLog(ServiceMetricCollectorSupport.class);
    private final BlockingQueue<MetricDatum> queue;

    protected ServiceMetricCollectorSupport(BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
    }

    @Override
    public void collectByteThroughput(ByteThroughputProvider provider) {
        block2: {
            try {
                this.collectByteThroughput0(provider);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Ignoring unexpected failure", (Throwable)ex);
            }
        }
    }

    double bytesPerSecond(double byteCount, double durationNano) {
        double bytesPerSec;
        if (byteCount < 0.0 || durationNano < 0.0) {
            throw new IllegalArgumentException();
        }
        if (durationNano == 0.0) {
            durationNano = 1.0;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Set zero to one to avoid division by zero; but should never get here!");
            }
        }
        if ((bytesPerSec = byteCount / durationNano * NANO_PER_SEC) == 0.0 && log.isDebugEnabled()) {
            log.debug((Object)"zero bytes per sec.  Really ?");
        }
        return bytesPerSec;
    }

    private void collectByteThroughput0(ByteThroughputProvider provider) {
        ThroughputMetricType throughputType = provider.getThroughputMetricType();
        ServiceMetricType byteCountType = throughputType.getByteCountMetricType();
        Set<MetricType> metrics = AwsSdkMetrics.getPredefinedMetrics();
        double byteCount = provider.getByteCount();
        double durationNano = provider.getDurationNano();
        double bytesPerSec = this.bytesPerSecond(byteCount, durationNano);
        if (metrics.contains(throughputType)) {
            Dimension throughputDimension = new Dimension().withName(Dimensions.MetricType.name()).withValue(throughputType.name());
            MetricDatum throughputDatum = new MetricDatum().withMetricName(throughputType.getServiceName()).withDimensions(throughputDimension).withUnit(StandardUnit.BytesSecond).withValue(bytesPerSec);
            this.addMetricsToQueue(throughputDatum);
        }
        if (metrics.contains(byteCountType)) {
            Dimension byteCountDimension = new Dimension().withName(Dimensions.MetricType.name()).withValue(byteCountType.name());
            MetricDatum byteCountDatum = new MetricDatum().withMetricName(byteCountType.getServiceName()).withDimensions(byteCountDimension).withUnit(StandardUnit.Bytes).withValue(byteCount);
            this.addMetricsToQueue(byteCountDatum);
        }
    }

    @Override
    public void collectLatency(ServiceLatencyProvider provider) {
        ServiceMetricType type = provider.getServiceMetricType();
        Set<MetricType> metrics = AwsSdkMetrics.getPredefinedMetrics();
        if (metrics.contains(type)) {
            Dimension dim = new Dimension().withName(Dimensions.MetricType.name()).withValue(type.name());
            MetricDatum datum = new MetricDatum().withMetricName(type.getServiceName()).withDimensions(dim).withUnit(StandardUnit.Milliseconds).withValue(provider.getDurationMilli());
            this.addMetricsToQueue(datum);
        }
    }

    protected boolean addMetricsToQueue(MetricDatum metric) {
        return this.queue.add(metric);
    }
}

