/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.auth.Signer;
import com.amazonaws.internal.config.SignerType;
import org.apache.http.annotation.Immutable;

@Immutable
public class SignerConfig {
    private final SignerType signerType;
    private final boolean doubleUrlEncode;

    SignerConfig(SignerType signerType, boolean doubleUrlEncode) {
        this.signerType = signerType;
        this.doubleUrlEncode = doubleUrlEncode;
    }

    SignerConfig(SignerConfig from) {
        this.signerType = from.getSignerType();
        this.doubleUrlEncode = from.isDoubleUrlEncode();
    }

    SignerConfig(SignerType signerType) {
        this(signerType, false);
    }

    public SignerType getSignerType() {
        return this.signerType;
    }

    public boolean isDoubleUrlEncode() {
        return this.doubleUrlEncode;
    }

    public String toString() {
        return (Object)((Object)this.signerType) + ": doubleUrlEncode=" + this.doubleUrlEncode;
    }

    public Signer computeSigner() {
        switch (this.signerType) {
            case AWS4SignerType: {
                return this.signerType.createV4Signer(this.doubleUrlEncode);
            }
            case AWS3SignerType: 
            case QueryStringSignerType: 
            case CloudFrontSignerType: {
                return this.signerType.createSigner();
            }
        }
        return null;
    }
}

