/*
 * Decompiled with CFR 0.152.
 */
package com.helger.statistics.impl;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.statistics.api.IStatisticsHandlerKeyedNumeric;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public abstract class AbstractStatisticsHandlerKeyedNumeric
implements IStatisticsHandlerKeyedNumeric {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Value> m_aMap = new CommonsHashMap();

    @Override
    @Nonnegative
    public final int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllKeys() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addValue(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLock().lock();
        try {
            Value value = (Value)this.m_aMap.get((Object)string);
            if (value == null) {
                this.m_aMap.put((Object)string, (Object)new Value(l));
            } else {
                value.add(l);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @CheckForSigned
    public final int getInvocationCount(@Nullable String string) {
        return this.m_aRWLock.readLockedInt(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1 : value.getInvocationCount();
        });
    }

    @Override
    public final @Nullable BigInteger getSum(@Nullable String string) {
        return (BigInteger)this.m_aRWLock.readLockedGet(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? null : value.getSum();
        });
    }

    @Override
    @CheckForSigned
    public final long getMin(@Nullable String string) {
        return this.m_aRWLock.readLockedLong(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1L : value.getMin();
        });
    }

    @Override
    @CheckForSigned
    public final long getAverage(@Nullable String string) {
        return this.m_aRWLock.readLockedLong(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1L : value.getAverage();
        });
    }

    @Override
    @CheckForSigned
    public long getMax(@Nullable String string) {
        return this.m_aRWLock.readLockedLong(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1L : value.getMax();
        });
    }

    private static final class Value {
        private int m_nInvocationCount = 1;
        private long m_nMin;
        private long m_nMax;
        private BigInteger m_aSum;

        public Value(long l) {
            this.m_nMin = l;
            this.m_nMax = l;
            this.m_aSum = BigInteger.valueOf(l);
        }

        public void add(long l) {
            ++this.m_nInvocationCount;
            if (l < this.m_nMin) {
                this.m_nMin = l;
            }
            if (l > this.m_nMax) {
                this.m_nMax = l;
            }
            this.m_aSum = this.m_aSum.add(BigInteger.valueOf(l));
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        @CheckForSigned
        public long getMin() {
            return this.m_nMin;
        }

        @CheckForSigned
        public long getMax() {
            return this.m_nMax;
        }

        public @NonNull BigInteger getSum() {
            return this.m_aSum;
        }

        @CheckForSigned
        public long getAverage() {
            return this.m_aSum.divide(BigInteger.valueOf(this.m_nInvocationCount)).longValue();
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("min", this.m_nMin).append("max", this.m_nMax).append("sum", (Object)this.m_aSum).getToString();
        }
    }
}

