/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.hashcode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.util.Arrays;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class HashCodeCalculator {
    public static final int INITIAL_HASHCODE = 17;
    public static final int MULTIPLIER = 31;
    public static final int HASHCODE_NULL = 129;
    private static final HashCodeCalculator INSTANCE = new HashCodeCalculator();

    private HashCodeCalculator() {
    }

    public static int hashCode(boolean bl) {
        return bl ? 1231 : 1237;
    }

    public static int hashCode(byte by) {
        return by;
    }

    public static int hashCode(char c) {
        return c;
    }

    public static long hashCode(double d) {
        return d == 0.0 ? 0L : Double.doubleToLongBits(d);
    }

    public static int hashCode(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    public static int hashCode(short s) {
        return s;
    }

    public static int hashCode(@Nullable Object object) {
        return object == null ? 129 : object.hashCode();
    }

    public static int append(int n, boolean bl) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(bl));
    }

    public static int append(int n, byte by) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(by));
    }

    public static int append(int n, char c) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(c));
    }

    public static int append(int n, double d) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(d));
    }

    public static int append(int n, float f) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(f));
    }

    public static int append(int n, int n2) {
        return n * 31 + n2;
    }

    public static int append(int n, long l) {
        int n2 = HashCodeCalculator.append(n, (int)(l >>> 32));
        return HashCodeCalculator.append(n2, (int)(l & 0xFFFFFFFFL));
    }

    public static int append(int n, short s) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(s));
    }

    public static int append(int n, @Nullable Object object) {
        return HashCodeCalculator.append(n, HashCodeCalculator.hashCode(object));
    }

    public static int hashCode(boolean @NonNull [] blArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(blArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, blArray[i]);
        }
        return n3;
    }

    public static int hashCode(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, byArray[i]);
        }
        return n3;
    }

    public static int hashCode(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, cArray[i]);
        }
        return n3;
    }

    public static int hashCode(double @NonNull [] dArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(dArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, dArray[i]);
        }
        return n3;
    }

    public static int hashCode(float @NonNull [] fArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(fArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, fArray[i]);
        }
        return n3;
    }

    public static int hashCode(int @NonNull [] nArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(nArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, nArray[i]);
        }
        return n3;
    }

    public static int hashCode(long @NonNull [] lArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(lArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, lArray[i]);
        }
        return n3;
    }

    public static int hashCode(short @NonNull [] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(sArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, sArray[i]);
        }
        return n3;
    }

    public static int hashCode(@NonNull Object[] objectArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(objectArray, n, n2);
        int n3 = 17;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = HashCodeCalculator.append(n3, objectArray[i]);
        }
        return n3;
    }

    public static int append(int n, boolean @Nullable [] blArray) {
        return HashCodeCalculator.append(n, blArray == null ? 129 : Arrays.hashCode(blArray));
    }

    public static int append(int n, boolean @Nullable [] blArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, blArray == null ? 129 : HashCodeCalculator.hashCode(blArray, n2, n3));
    }

    public static int append(int n, byte @Nullable [] byArray) {
        return HashCodeCalculator.append(n, byArray == null ? 129 : Arrays.hashCode(byArray));
    }

    public static int append(int n, byte @Nullable [] byArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, byArray == null ? 129 : HashCodeCalculator.hashCode(byArray, n2, n3));
    }

    public static int append(int n, char @Nullable [] cArray) {
        return HashCodeCalculator.append(n, cArray == null ? 129 : Arrays.hashCode(cArray));
    }

    public static int append(int n, char @Nullable [] cArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, cArray == null ? 129 : HashCodeCalculator.hashCode(cArray, n2, n3));
    }

    public static int append(int n, double @Nullable [] dArray) {
        return HashCodeCalculator.append(n, dArray == null ? 129 : Arrays.hashCode(dArray));
    }

    public static int append(int n, double @Nullable [] dArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, dArray == null ? 129 : HashCodeCalculator.hashCode(dArray, n2, n3));
    }

    public static int append(int n, float @Nullable [] fArray) {
        return HashCodeCalculator.append(n, fArray == null ? 129 : Arrays.hashCode(fArray));
    }

    public static int append(int n, float @Nullable [] fArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, fArray == null ? 129 : HashCodeCalculator.hashCode(fArray, n2, n3));
    }

    public static int append(int n, int @Nullable [] nArray) {
        return HashCodeCalculator.append(n, nArray == null ? 129 : Arrays.hashCode(nArray));
    }

    public static int append(int n, int @Nullable [] nArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, nArray == null ? 129 : HashCodeCalculator.hashCode(nArray, n2, n3));
    }

    public static int append(int n, long @Nullable [] lArray) {
        return HashCodeCalculator.append(n, lArray == null ? 129 : Arrays.hashCode(lArray));
    }

    public static int append(int n, long @Nullable [] lArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, lArray == null ? 129 : HashCodeCalculator.hashCode(lArray, n2, n3));
    }

    public static int append(int n, short @Nullable [] sArray) {
        return HashCodeCalculator.append(n, sArray == null ? 129 : Arrays.hashCode(sArray));
    }

    public static int append(int n, short @Nullable [] sArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, sArray == null ? 129 : HashCodeCalculator.hashCode(sArray, n2, n3));
    }

    public static int append(int n, @Nullable Object[] objectArray) {
        return HashCodeCalculator.append(n, objectArray == null ? 129 : Arrays.hashCode(objectArray));
    }

    public static int append(int n, @Nullable Object[] objectArray, @Nonnegative int n2, @Nonnegative int n3) {
        return HashCodeCalculator.append(n, objectArray == null ? 129 : HashCodeCalculator.hashCode(objectArray, n2, n3));
    }
}

