/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.dimension;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.dimension.IHasDimensionInt;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.MathHelper;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@Immutable
public class SizeInt
implements IHasDimensionInt {
    private final int m_nWidth;
    private final int m_nHeight;

    public SizeInt(@NonNull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeInt(@Nonnegative int n, @Nonnegative int n2) {
        this.m_nWidth = ValueEnforcer.isGE0(n, "Width");
        this.m_nHeight = ValueEnforcer.isGE0(n2, "Height");
    }

    @Override
    @Nonnegative
    public int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public int getHeight() {
        return this.m_nHeight;
    }

    @CheckReturnValue
    public @NonNull SizeInt getBestMatchingSize(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0(n, "MaxWidth");
        ValueEnforcer.isGT0(n2, "MaxHeight");
        double d = MathHelper.getDividedDouble(this.m_nWidth, n);
        double d2 = MathHelper.getDividedDouble(this.m_nHeight, n2);
        if (d > d2) {
            if (this.m_nWidth > n) {
                return new SizeInt(n, (int)((double)this.m_nHeight / d));
            }
        } else if (this.m_nHeight > n2) {
            return new SizeInt((int)((double)this.m_nWidth / d2), n2);
        }
        return this;
    }

    @CheckReturnValue
    public @NonNull SizeInt getScaledToWidth(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "NewWidth");
        if (this.m_nWidth == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nWidth);
        return new SizeInt(n, (int)((double)this.m_nHeight * d));
    }

    @CheckReturnValue
    public @NonNull SizeInt getScaledToHeight(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "NewHeight");
        if (this.m_nHeight == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nHeight);
        return new SizeInt((int)((double)this.m_nWidth * d), n);
    }

    @CheckReturnValue
    public @NonNull SizeInt getAdded(@NonNull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToAdd");
        return new SizeInt(this.m_nWidth + iHasDimensionInt.getWidth(), this.m_nHeight + iHasDimensionInt.getHeight());
    }

    @CheckReturnValue
    public @NonNull SizeInt getSubtracted(@NonNull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToSubtract");
        return new SizeInt(this.m_nWidth - iHasDimensionInt.getWidth(), this.m_nHeight - iHasDimensionInt.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeInt sizeInt = (SizeInt)object;
        return this.m_nWidth == sizeInt.m_nWidth && this.m_nHeight == sizeInt.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).getToString();
    }
}

