/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.classloader;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ClassLoaderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderHelper.class);
    private static final ClassLoaderHelper INSTANCE = new ClassLoaderHelper();

    protected ClassLoaderHelper() {
    }

    public static @NonNull ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static @Nullable ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setContextClassLoader(@NonNull ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public static @Nullable ClassLoader getClassClassLoader(@NonNull Class<?> clazz) {
        return clazz.getClassLoader();
    }

    public static @Nullable ClassLoader getParentClassLoader(@NonNull ClassLoader classLoader) {
        return classLoader.getParent();
    }

    public static @NonNull ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderHelper.getContextClassLoader();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderHelper.getClassClassLoader(ClassLoaderHelper.class);
        }
        return classLoader;
    }

    protected static @NonNull String internalGetPathWithoutLeadingSlash(@NonNull @Nonempty String string) {
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    public static @Nullable URL getResource(@NonNull ClassLoader classLoader, @NonNull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        try {
            return classLoader.getResource(string2);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("Unexpected runtime exception gathering resource '" + string2 + "'", (Throwable)runtimeException);
            return null;
        }
    }

    public static @NonNull Enumeration<URL> getResources(@NonNull ClassLoader classLoader, @NonNull @Nonempty String string) throws IOException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        return classLoader.getResources(string2);
    }

    public static @Nullable InputStream getResourceAsStream(@NonNull ClassLoader classLoader, @NonNull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper.internalGetPathWithoutLeadingSlash(string);
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        return StreamHelper.checkForInvalidFilterInputStream(inputStream);
    }
}

