/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.SchemaParser;
import com.coxautodev.graphql.tools.SchemaParserBuilder;
import com.coxautodev.graphql.tools.SchemaParserDictionary;
import com.coxautodev.graphql.tools.SchemaParserOptions;
import com.oembedler.moon.graphql.boot.ClasspathResourceSchemaStringProvider;
import com.oembedler.moon.graphql.boot.SchemaStringProvider;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLSchemaProvider;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SchemaParser.class})
public class GraphQLJavaToolsAutoConfiguration {
    @Autowired(required=false)
    private SchemaParserDictionary dictionary;
    @Autowired(required=false)
    private GraphQLScalarType[] scalars;
    @Autowired(required=false)
    private SchemaParserOptions options;

    @Bean
    @ConditionalOnMissingBean
    public SchemaStringProvider schemaStringProvider() {
        return new ClasspathResourceSchemaStringProvider();
    }

    @Bean
    @ConditionalOnBean(value={GraphQLResolver.class})
    @ConditionalOnMissingBean
    public SchemaParser schemaParser(List<GraphQLResolver<?>> resolvers, SchemaStringProvider schemaStringProvider) throws IOException {
        SchemaParserBuilder builder = this.dictionary != null ? new SchemaParserBuilder(this.dictionary) : new SchemaParserBuilder();
        List<String> schemaStrings = schemaStringProvider.schemaStrings();
        schemaStrings.forEach(arg_0 -> ((SchemaParserBuilder)builder).schemaString(arg_0));
        if (this.scalars != null) {
            builder.scalars(this.scalars);
        }
        if (this.options != null) {
            builder.options(this.options);
        }
        return builder.resolvers(resolvers).build();
    }

    @Bean
    @ConditionalOnBean(value={SchemaParser.class})
    @ConditionalOnMissingBean(value={GraphQLSchema.class, GraphQLSchemaProvider.class})
    public GraphQLSchema graphQLSchema(SchemaParser schemaParser) {
        return schemaParser.makeExecutableSchema();
    }
}

