/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PropertyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final PropertyMap EMPTY_MAP = new PropertyMap((Map<String, Property>)ImmutableMap.of());
    private static final Function<ObjectType, PropertyMap> PROP_MAP_FROM_TYPE = new Function<ObjectType, PropertyMap>(){

        public PropertyMap apply(ObjectType t) {
            return t.getPropertyMap();
        }
    };
    private ObjectType parentSource = null;
    private final Map<String, Property> properties;

    PropertyMap() {
        this(Maps.newTreeMap());
    }

    private PropertyMap(Map<String, Property> underlyingMap) {
        this.properties = underlyingMap;
    }

    static PropertyMap immutableEmptyMap() {
        return EMPTY_MAP;
    }

    void setParentSource(ObjectType ownerType) {
        if (this != EMPTY_MAP) {
            this.parentSource = ownerType;
        }
    }

    PropertyMap getPrimaryParent() {
        if (this.parentSource == null) {
            return null;
        }
        ObjectType iProto = this.parentSource.getImplicitPrototype();
        return iProto == null ? null : iProto.getPropertyMap();
    }

    Iterable<PropertyMap> getSecondaryParents() {
        if (this.parentSource == null) {
            return ImmutableList.of();
        }
        Iterable<ObjectType> extendedInterfaces = this.parentSource.getCtorExtendedInterfaces();
        if (Iterables.isEmpty(extendedInterfaces)) {
            return ImmutableList.of();
        }
        return Iterables.transform(extendedInterfaces, PROP_MAP_FROM_TYPE);
    }

    Property getSlot(String name) {
        Property prop;
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent != null && (prop = primaryParent.getSlot(name)) != null) {
            return prop;
        }
        for (PropertyMap p : this.getSecondaryParents()) {
            Property prop2;
            if (p == null || (prop2 = p.getSlot(name)) == null) continue;
            return prop2;
        }
        return null;
    }

    Property getOwnProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    int getPropertiesCount() {
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent == null) {
            return this.properties.size();
        }
        HashSet<String> props = new HashSet<String>();
        this.collectPropertyNames(props);
        return props.size();
    }

    boolean hasOwnProperty(String propertyName) {
        return this.properties.get(propertyName) != null;
    }

    boolean hasProperty(String propertyName) {
        return this.getSlot(propertyName) != null;
    }

    Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    void collectPropertyNames(Set<String> props) {
        props.addAll(this.properties.keySet());
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent != null) {
            primaryParent.collectPropertyNames(props);
        }
        for (PropertyMap p : this.getSecondaryParents()) {
            if (p == null) continue;
            p.collectPropertyNames(props);
        }
    }

    boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    void putProperty(String name, Property newProp) {
        Property oldProp = this.properties.get(name);
        if (oldProp != null) {
            newProp.setJSDocInfo(oldProp.getJSDocInfo());
        }
        this.properties.put(name, newProp);
    }

    Iterable<Property> values() {
        return this.properties.values();
    }
}

