/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.Typedef;

public class Declaration {
    private JSType simpleType;
    private Typedef typedef;
    private NamespaceLit namespaceLit;
    private EnumType enumType;
    private DeclaredTypeRegistry functionScope;
    private NominalType.RawNominalType nominal;
    private boolean isFormal;
    private boolean isTypeVar;
    private boolean isConstant;
    private boolean isFromExterns;
    private boolean isForwardDeclaration;

    public Declaration(JSType simpleType, Typedef typedef, NamespaceLit namespaceLit, EnumType enumType, DeclaredTypeRegistry functionScope, NominalType.RawNominalType nominal, boolean isFormal, boolean isTypeVar, boolean isConstant, boolean isFromExterns, boolean isForwardDeclaration) {
        this.simpleType = simpleType;
        this.typedef = typedef;
        this.namespaceLit = namespaceLit;
        this.enumType = enumType;
        this.functionScope = functionScope;
        this.nominal = nominal;
        this.isFormal = isFormal;
        this.isTypeVar = isTypeVar;
        this.isConstant = isConstant;
        this.isFromExterns = isFromExterns;
        this.isForwardDeclaration = isForwardDeclaration;
        this.checkValid();
    }

    private void checkValid() {
        if (this.simpleType != null) {
            Preconditions.checkState((this.typedef == null && this.namespaceLit == null && this.enumType == null && this.functionScope == null && this.nominal == null ? 1 : 0) != 0);
        }
        if (this.typedef != null) {
            Preconditions.checkState((this.simpleType == null && this.namespaceLit == null && this.enumType == null && this.functionScope == null && this.nominal == null ? 1 : 0) != 0);
        }
        if (this.namespaceLit != null) {
            Preconditions.checkState((this.simpleType == null && this.typedef == null && this.enumType == null && this.functionScope == null && this.nominal == null ? 1 : 0) != 0);
        }
        if (this.enumType != null) {
            Preconditions.checkState((this.simpleType == null && this.typedef == null && this.namespaceLit == null && this.functionScope == null && this.nominal == null ? 1 : 0) != 0);
        }
        if (this.functionScope != null || this.nominal != null) {
            Preconditions.checkState((this.simpleType == null && this.typedef == null && this.namespaceLit == null && this.enumType == null ? 1 : 0) != 0);
        }
    }

    public JSType getTypeOfSimpleDecl() {
        return this.simpleType;
    }

    public Typedef getTypedef() {
        return this.typedef;
    }

    public NamespaceLit getNamespaceLit() {
        return this.namespaceLit;
    }

    public EnumType getEnum() {
        return this.enumType;
    }

    public DeclaredTypeRegistry getFunctionScope() {
        return this.functionScope;
    }

    public NominalType.RawNominalType getNominal() {
        return this.nominal;
    }

    public boolean isFormal() {
        return this.isFormal;
    }

    public boolean isTypeVar() {
        return this.isTypeVar;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isFromExterns() {
        return this.isFromExterns;
    }

    public boolean isForwardDeclaration() {
        return this.isForwardDeclaration;
    }

    public Namespace getNamespace() {
        if (this.namespaceLit != null) {
            return this.namespaceLit;
        }
        if (this.enumType != null) {
            return this.enumType;
        }
        if (this.nominal != null) {
            return this.nominal;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("simpleType", (Object)this.simpleType).add("typedef", (Object)this.typedef).add("namespace", (Object)this.namespaceLit).add("enum", (Object)this.enumType).add("scope", (Object)this.functionScope).add("nominal", (Object)this.nominal).toString();
    }
}

