/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NominalType {
    private final ImmutableMap<String, JSType> typeMap;
    private final RawNominalType rawType;

    private NominalType(ImmutableMap<String, JSType> typeMap, RawNominalType rawType) {
        Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll((Collection)rawType.typeParameters) && rawType.typeParameters.containsAll((Collection)typeMap.keySet()) ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.rawType = rawType;
    }

    public RawNominalType getRawNominalType() {
        Preconditions.checkState((boolean)this.typeMap.isEmpty());
        return this.rawType;
    }

    ObjectKind getObjectKind() {
        return this.rawType.objectKind;
    }

    public boolean isStruct() {
        return this.rawType.isStruct();
    }

    public boolean isDict() {
        return this.rawType.isDict();
    }

    NominalType instantiateGenerics(List<JSType> types) {
        Preconditions.checkState((types.size() == this.rawType.typeParameters.size() ? 1 : 0) != 0);
        HashMap<String, JSType> typeMap = new HashMap<String, JSType>();
        for (int i = 0; i < this.rawType.typeParameters.size(); ++i) {
            typeMap.put((String)this.rawType.typeParameters.get(i), types.get(i));
        }
        return this.instantiateGenerics(typeMap);
    }

    NominalType instantiateGenerics(Map<String, JSType> newTypeMap) {
        if (newTypeMap.isEmpty()) {
            return this;
        }
        if (!this.rawType.isGeneric() && !this.hasFreeTypeVars(new HashSet<String>())) {
            return this.rawType.wrappedAsNominal;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this.typeMap.isEmpty()) {
            for (String oldKey : this.typeMap.keySet()) {
                builder.put((Object)oldKey, (Object)((JSType)this.typeMap.get((Object)oldKey)).substituteGenerics(newTypeMap));
            }
        } else {
            for (Map.Entry<String, JSType> newTypeEntry : newTypeMap.entrySet()) {
                String newKey = newTypeEntry.getKey();
                if (!this.rawType.typeParameters.contains((Object)newKey)) continue;
                builder.put((Object)newKey, (Object)newTypeEntry.getValue());
            }
        }
        return new NominalType((ImmutableMap<String, JSType>)builder.build(), this.rawType);
    }

    boolean hasFreeTypeVars(Set<String> boundTypeVars) {
        for (JSType t : this.typeMap.values()) {
            if (!t.hasFreeTypeVars(boundTypeVars)) continue;
            return true;
        }
        return this.rawType.hasFreeTypeVars(boundTypeVars);
    }

    public String getName() {
        return this.rawType.name;
    }

    public RawNominalType getId() {
        return this.rawType;
    }

    public boolean isClass() {
        return this.rawType.isClass();
    }

    public boolean isInterface() {
        return !this.rawType.isClass();
    }

    public boolean isFinalized() {
        return this.rawType.isFinalized;
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        return this.rawType.getAllPropsOfInterface();
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        return this.rawType.getAllPropsOfClass();
    }

    public NominalType getInstantiatedSuperclass() {
        Preconditions.checkState((boolean)this.rawType.isFinalized);
        if (this.rawType.superClass == null) {
            return null;
        }
        return this.rawType.superClass.instantiateGenerics((Map<String, JSType>)this.typeMap);
    }

    public ImmutableSet<NominalType> getInstantiatedInterfaces() {
        Preconditions.checkState((boolean)this.rawType.isFinalized);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.interfaces) {
            result.add((Object)interf.instantiateGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    Property getProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPropDeclaredType(String pname) {
        JSType type = this.rawType.getPropDeclaredType(pname);
        return type == null ? null : type.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public boolean hasConstantProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p != null && p.isConstant();
    }

    JSType createConstructorObject(FunctionType ctorFn) {
        Preconditions.checkState((boolean)this.typeMap.isEmpty());
        return this.rawType.createConstructorObject(ctorFn);
    }

    boolean isSubclassOf(NominalType other) {
        RawNominalType otherRawType = other.rawType;
        if (this.rawType.isInterface && !otherRawType.isInterface) {
            return false;
        }
        if (!this.rawType.isInterface && otherRawType.isInterface) {
            if (this.rawType.interfaces == null) {
                return false;
            }
            for (NominalType i : this.rawType.interfaces) {
                if (!i.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubclassOf(other)) continue;
                return true;
            }
            return false;
        }
        if (this.rawType.isInterface && otherRawType.isInterface) {
            if (this.rawType.equals(otherRawType)) {
                for (String typeVar : this.rawType.getTypeParameters()) {
                    if (((JSType)this.typeMap.get((Object)typeVar)).isSubtypeOf((JSType)other.typeMap.get((Object)typeVar))) continue;
                    return false;
                }
                return true;
            }
            if (this.rawType.interfaces == null) {
                return false;
            }
            for (NominalType i : this.rawType.interfaces) {
                if (!i.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubclassOf(other)) continue;
                return true;
            }
            return false;
        }
        if (this.rawType.equals(otherRawType)) {
            for (String typeVar : this.rawType.getTypeParameters()) {
                Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
                Preconditions.checkState((boolean)other.typeMap.containsKey((Object)typeVar));
                if (((JSType)this.typeMap.get((Object)typeVar)).isSubtypeOf((JSType)other.typeMap.get((Object)typeVar))) continue;
                return false;
            }
            return true;
        }
        if (this.rawType.superClass == null) {
            return false;
        }
        return this.rawType.superClass.instantiateGenerics((Map<String, JSType>)this.typeMap).isSubclassOf(other);
    }

    static NominalType pickSuperclass(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isSubclassOf(c2)) {
            return c2;
        }
        return c2.isSubclassOf(c1) ? c1 : null;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isSubclassOf(c2)) {
            return c1;
        }
        return c2.isSubclassOf(c1) ? c2 : null;
    }

    boolean unifyWith(NominalType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if (this.rawType != other.rawType) {
            return false;
        }
        if (this.rawType.typeParameters.isEmpty()) {
            return true;
        }
        Preconditions.checkState((!this.typeMap.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!other.typeMap.isEmpty() ? 1 : 0) != 0);
        boolean hasUnified = true;
        for (String typeParam : this.rawType.typeParameters) {
            hasUnified = hasUnified && ((JSType)this.typeMap.get((Object)typeParam)).unifyWith((JSType)other.typeMap.get((Object)typeParam), typeParameters, typeMultimap);
        }
        return hasUnified;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.rawType.name);
        this.rawType.appendGenericSuffixTo(builder, this.typeMap);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typeMap, this.rawType);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Preconditions.checkState((boolean)(other instanceof NominalType));
        NominalType o = (NominalType)other;
        return Objects.equals(this.typeMap, o.typeMap) && this.rawType.equals(o.rawType);
    }

    public static class RawNominalType
    extends Namespace {
        private final String name;
        private PersistentMap<String, Property> classProps = PersistentMap.create();
        private PersistentMap<String, Property> protoProps = PersistentMap.create();
        boolean isFinalized = false;
        private NominalType superClass = null;
        private ImmutableSet<NominalType> interfaces = null;
        private final boolean isInterface;
        private ImmutableSet<String> allProps = null;
        private final NominalType wrappedAsNominal;
        private final JSType wrappedAsJSType;
        private final JSType wrappedAsNullableJSType;
        private final ImmutableList<String> typeParameters;
        private final ObjectKind objectKind;
        private FunctionType ctorFn;
        private HasFreeTypeVars hasFreeTypeVars = HasFreeTypeVars.UNKNOWN;

        private RawNominalType(String name, ImmutableList<String> typeParameters, boolean isInterface, ObjectKind objectKind) {
            Preconditions.checkNotNull((Object)objectKind);
            if (typeParameters == null) {
                typeParameters = ImmutableList.of();
            }
            this.name = name;
            this.typeParameters = typeParameters;
            this.isInterface = isInterface;
            this.objectKind = objectKind;
            this.wrappedAsNominal = new NominalType(ImmutableMap.of(), this);
            this.wrappedAsJSType = JSType.fromObjectType(ObjectType.fromNominalType(this.wrappedAsNominal));
            this.wrappedAsNullableJSType = JSType.join(JSType.NULL, this.wrappedAsJSType);
        }

        public static RawNominalType makeUnrestrictedClass(QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(name.toString(), typeParameters, false, ObjectKind.UNRESTRICTED);
        }

        public static RawNominalType makeStructClass(QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(name.toString(), typeParameters, false, ObjectKind.STRUCT);
        }

        public static RawNominalType makeDictClass(QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(name.toString(), typeParameters, false, ObjectKind.DICT);
        }

        public static RawNominalType makeInterface(QualifiedName name, ImmutableList<String> typeParameters) {
            return new RawNominalType(name.toString(), typeParameters, true, ObjectKind.STRUCT);
        }

        public String getName() {
            return this.name;
        }

        public boolean isClass() {
            return !this.isInterface;
        }

        boolean isGeneric() {
            return !this.typeParameters.isEmpty();
        }

        public boolean isStruct() {
            return this.objectKind.isStruct();
        }

        public boolean isDict() {
            return this.objectKind.isDict();
        }

        ImmutableList<String> getTypeParameters() {
            return this.typeParameters;
        }

        public void setCtorFunction(FunctionType ctorFn) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            this.ctorFn = ctorFn;
        }

        private boolean hasAncestorClass(RawNominalType ancestor) {
            Preconditions.checkState((boolean)ancestor.isClass());
            if (this == ancestor) {
                return true;
            }
            if (this.superClass == null) {
                return false;
            }
            return this.superClass.rawType.hasAncestorClass(ancestor);
        }

        public boolean addSuperClass(NominalType superClass) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            Preconditions.checkState((this.superClass == null ? 1 : 0) != 0);
            if (superClass.rawType.hasAncestorClass(this)) {
                return false;
            }
            this.superClass = superClass;
            return true;
        }

        private boolean hasAncestorInterface(RawNominalType ancestor) {
            Preconditions.checkState((boolean)ancestor.isInterface);
            if (this == ancestor) {
                return true;
            }
            if (this.interfaces == null) {
                return false;
            }
            for (NominalType superInter : this.interfaces) {
                if (!superInter.rawType.hasAncestorInterface(ancestor)) continue;
                return true;
            }
            return false;
        }

        public boolean addInterfaces(ImmutableSet<NominalType> interfaces) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
            Preconditions.checkNotNull(interfaces);
            if (this.isInterface) {
                for (NominalType interf : interfaces) {
                    if (!interf.rawType.hasAncestorInterface(this)) continue;
                    this.interfaces = ImmutableSet.of();
                    return false;
                }
            }
            this.interfaces = interfaces;
            return true;
        }

        public NominalType getSuperClass() {
            return this.superClass;
        }

        public ImmutableSet<NominalType> getInterfaces() {
            return this.interfaces;
        }

        private Property getOwnProp(String pname) {
            Property p = (Property)this.classProps.get(pname);
            if (p != null) {
                return p;
            }
            return (Property)this.protoProps.get(pname);
        }

        private Property getPropFromClass(String pname) {
            Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
            Property p = this.getOwnProp(pname);
            if (p != null) {
                return p;
            }
            if (this.superClass != null && (p = this.superClass.getProp(pname)) != null) {
                return p;
            }
            return null;
        }

        private Property getPropFromInterface(String pname) {
            Preconditions.checkState((boolean)this.isInterface);
            Property p = (Property)this.protoProps.get(pname);
            if (p != null) {
                return p;
            }
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    p = interf.getProp(pname);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        private Property getProp(String pname) {
            if (this.isInterface) {
                return this.getPropFromInterface(pname);
            }
            return this.getPropFromClass(pname);
        }

        public boolean mayHaveOwnProp(String pname) {
            return this.getOwnProp(pname) != null;
        }

        public boolean mayHaveProp(String pname) {
            return this.getProp(pname) != null;
        }

        @Override
        public JSType getPropDeclaredType(String pname) {
            Property p = this.getProp(pname);
            if (p == null) {
                return null;
            }
            if (p.getDeclaredType() == null && this.superClass != null) {
                return this.superClass.getPropDeclaredType(pname);
            }
            return p.getDeclaredType();
        }

        public Set<String> getAllOwnProps() {
            HashSet<String> ownProps = new HashSet<String>();
            ownProps.addAll(this.classProps.keySet());
            ownProps.addAll(this.protoProps.keySet());
            return ownProps;
        }

        private ImmutableSet<String> getAllPropsOfInterface() {
            Preconditions.checkState((boolean)this.isInterface);
            Preconditions.checkState((boolean)this.isFinalized);
            if (this.allProps == null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (this.interfaces != null) {
                    for (NominalType interf : this.interfaces) {
                        builder.addAll(interf.rawType.getAllPropsOfInterface());
                    }
                }
                this.allProps = builder.addAll(this.protoProps.keySet()).build();
            }
            return this.allProps;
        }

        private ImmutableSet<String> getAllPropsOfClass() {
            Preconditions.checkState((!this.isInterface ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.isFinalized);
            if (this.allProps == null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (this.superClass != null) {
                    Preconditions.checkState((boolean)this.superClass.typeMap.isEmpty());
                    builder.addAll(this.superClass.rawType.getAllPropsOfClass());
                }
                this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
            }
            return this.allProps;
        }

        private boolean hasFreeTypeVars(Set<String> boundTypeVars) {
            switch (this.hasFreeTypeVars) {
                case UNKNOWN: {
                    this.hasFreeTypeVars = HasFreeTypeVars.CHECKING_NOW;
                    break;
                }
                case CHECKING_NOW: {
                    this.hasFreeTypeVars = HasFreeTypeVars.FALSE;
                    return false;
                }
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
            if (this.isGeneric()) {
                boundTypeVars.addAll((Collection<String>)this.typeParameters);
            }
            for (Property prop : this.classProps.values()) {
                if (!prop.hasFreeTypeVars(boundTypeVars)) continue;
                this.hasFreeTypeVars = HasFreeTypeVars.TRUE;
                return true;
            }
            for (Property prop : this.protoProps.values()) {
                if (!prop.hasFreeTypeVars(boundTypeVars)) continue;
                this.hasFreeTypeVars = HasFreeTypeVars.TRUE;
                return true;
            }
            if (this.interfaces != null) {
                for (NominalType nt : this.interfaces) {
                    if (!nt.hasFreeTypeVars(boundTypeVars)) continue;
                    this.hasFreeTypeVars = HasFreeTypeVars.TRUE;
                    return true;
                }
            }
            if (this.superClass != null && this.superClass.hasFreeTypeVars(boundTypeVars)) {
                this.hasFreeTypeVars = HasFreeTypeVars.TRUE;
                return true;
            }
            this.hasFreeTypeVars = HasFreeTypeVars.FALSE;
            return false;
        }

        public void addClassProperty(String pname, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (type == null && isConstant) {
                type = JSType.UNKNOWN;
            }
            this.classProps = this.classProps.with(pname, isConstant ? Property.makeConstant(type, type) : Property.make(type, type));
            if (this.protoProps.containsKey(pname)) {
                this.addProtoProperty(pname, type, isConstant);
            }
        }

        public void addUndeclaredClassProperty(String pname) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (this.mayHaveProp(pname)) {
                return;
            }
            this.classProps = this.classProps.with(pname, Property.make(JSType.UNKNOWN, null));
        }

        public void addProtoProperty(String pname, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (type == null && isConstant) {
                type = JSType.UNKNOWN;
            }
            if (this.classProps.containsKey(pname) && ((Property)this.classProps.get(pname)).getDeclaredType() == null) {
                this.classProps = this.classProps.without(pname);
            }
            this.protoProps = this.protoProps.with(pname, isConstant ? Property.makeConstant(type, type) : Property.make(type, type));
        }

        public void addUndeclaredProtoProperty(String pname) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            if (!this.protoProps.containsKey(pname) || ((Property)this.protoProps.get(pname)).getDeclaredType() == null) {
                this.protoProps = this.protoProps.with(pname, Property.make(JSType.UNKNOWN, null));
            }
        }

        private JSType createProtoObject() {
            return JSType.fromObjectType(ObjectType.makeObjectType(this.superClass, this.protoProps, null, false, ObjectKind.UNRESTRICTED));
        }

        public boolean hasCtorProp(String pname) {
            return super.hasProp(pname);
        }

        public void addCtorProperty(String pname, JSType type, boolean isConstant) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            super.addProperty(pname, type, isConstant);
        }

        public void addUndeclaredCtorProperty(String pname) {
            Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
            super.addUndeclaredProperty(pname, JSType.UNKNOWN, false);
        }

        public JSType getCtorPropDeclaredType(String pname) {
            return super.getPropDeclaredType(pname);
        }

        private JSType createConstructorObject(FunctionType ctorFn) {
            return this.withNamedTypes(ObjectType.makeObjectType(null, this.otherProps, ctorFn, ctorFn.isLoose(), ObjectKind.UNRESTRICTED));
        }

        private StringBuilder appendGenericSuffixTo(StringBuilder builder, Map<String, JSType> typeMap) {
            Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll((Collection<?>)this.typeParameters) ? 1 : 0) != 0);
            if (this.typeParameters.isEmpty()) {
                return builder;
            }
            boolean firstIteration = true;
            builder.append(".<");
            for (String typeParam : this.typeParameters) {
                JSType concrete;
                if (!firstIteration) {
                    builder.append(',');
                }
                if ((concrete = typeMap.get(typeParam)) != null) {
                    concrete.appendTo(builder);
                    continue;
                }
                builder.append(typeParam);
            }
            builder.append('>');
            return builder;
        }

        public RawNominalType finalizeNominalType() {
            Preconditions.checkState((this.ctorFn != null ? 1 : 0) != 0);
            if (this.interfaces == null) {
                this.interfaces = ImmutableSet.of();
            }
            this.addCtorProperty("prototype", this.createProtoObject(), false);
            this.hasFreeTypeVars(new HashSet<String>());
            Preconditions.checkState((this.hasFreeTypeVars == HasFreeTypeVars.TRUE || this.hasFreeTypeVars == HasFreeTypeVars.FALSE ? 1 : 0) != 0);
            this.isFinalized = true;
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.name);
            this.appendGenericSuffixTo(builder, (Map<String, JSType>)ImmutableMap.of());
            return builder.toString();
        }

        @Override
        public JSType toJSType() {
            Preconditions.checkState((this.ctorFn != null ? 1 : 0) != 0);
            return this.createConstructorObject(this.ctorFn);
        }

        public NominalType getAsNominalType() {
            return this.wrappedAsNominal;
        }

        public JSType getInstanceAsJSType() {
            return this.wrappedAsJSType;
        }

        public JSType getInstanceAsNullableJSType() {
            return this.wrappedAsNullableJSType;
        }

        private static enum HasFreeTypeVars {
            UNKNOWN,
            CHECKING_NOW,
            TRUE,
            FALSE;

        }
    }
}

