/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Set;

class DeclaredGlobalExternsOnWindow
extends NodeTraversal.AbstractShallowStatementCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> nodes = new LinkedHashSet<Node>();
    private boolean windowInExterns = false;

    public DeclaredGlobalExternsOnWindow(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        this.addWindowProperties();
    }

    private void addWindowProperties() {
        if (this.nodes.size() > 0 && this.windowInExterns) {
            for (Node node : this.nodes) {
                DeclaredGlobalExternsOnWindow.addExtern(node);
            }
            this.compiler.reportCodeChange();
        }
    }

    private static void addExtern(Node node) {
        Node getprop;
        String name = node.getString();
        JSDocInfo oldJSDocInfo = NodeUtil.getBestJSDocInfo(node);
        Node window = IR.name("window");
        Node string = IR.string(name);
        Node newNode = getprop = IR.getprop(window, string);
        if (oldJSDocInfo != null) {
            JSDocInfoBuilder builder;
            if (oldJSDocInfo.isConstructor() || oldJSDocInfo.isInterface() || oldJSDocInfo.hasEnumParameterType()) {
                Node nameNode = IR.name(name);
                newNode = IR.assign(getprop, nameNode);
                builder = new JSDocInfoBuilder(false);
                if (oldJSDocInfo.isConstructor()) {
                    builder.recordConstructor();
                }
                if (oldJSDocInfo.isInterface()) {
                    builder.recordInterface();
                }
                if (oldJSDocInfo.hasEnumParameterType()) {
                    builder.recordEnumParameterType(oldJSDocInfo.getEnumParameterType());
                }
            } else {
                builder = JSDocInfoBuilder.copyFrom(oldJSDocInfo);
            }
            builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"duplicate"));
            JSDocInfo jsDocInfo = builder.build(newNode);
            jsDocInfo.setAssociatedNode(newNode);
            newNode.setJSDocInfo(jsDocInfo);
        }
        NodeUtil.setDebugInformation(newNode, node, name);
        node.getParent().getParent().addChildToBack(IR.exprResult(newNode));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            this.nodes.add(n.getFirstChild());
        } else if (n.isVar()) {
            for (Node c : n.children()) {
                if (!c.getString().equals("location")) {
                    this.nodes.add(c);
                }
                if (this.windowInExterns || !c.getString().equals("window")) continue;
                this.windowInExterns = true;
            }
        }
    }
}

