/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CheckEventfulObjectDisposal
implements CompilerPass {
    static final DiagnosticType EVENTFUL_OBJECT_NOT_DISPOSED = DiagnosticType.error("JSC_EVENTFUL_OBJECT_NOT_DISPOSED", "eventful object created should be\n  * registered as disposable, or\n  * explicitly disposed of");
    static final DiagnosticType EVENTFUL_OBJECT_PURELY_LOCAL = DiagnosticType.error("JSC_EVENTFUL_OBJECT_PURELY_LOCAL", "a purely local eventful object cannot be disposed of later");
    static final DiagnosticType OVERWRITE_PRIVATE_EVENTFUL_OBJECT = DiagnosticType.error("JSC_OVERWRITE_PRIVATE_EVENTFUL_OBJECT", "private eventful object overwritten in subclass cannot be properly disposed of");
    static final DiagnosticType UNLISTEN_WITH_ANONBOUND = DiagnosticType.error("JSC_UNLISTEN_WITH_ANONBOUND", "an unlisten call with an anonymous or bound function does not result in the event being unlisted to");
    static final String DISPOSABLE_TYPE_NAME = "goog.Disposable";
    static final String EVENT_HANDLER_TYPE_NAME = "goog.events.EventHandler";
    JSType googDisposableType;
    JSType googEventsEventHandlerType;
    Set<JSType> eventfulTypes;
    final AbstractCompiler compiler;
    final JSTypeRegistry typeRegistry;
    public DisposalCheckingPolicy checkingPolicy;
    public Map<String, Set<String>> eventizes;
    static Map<String, EventfulObjectState> eventfulObjectMap;

    public CheckEventfulObjectDisposal(AbstractCompiler compiler, DisposalCheckingPolicy checkingPolicy) {
        this.compiler = compiler;
        this.checkingPolicy = checkingPolicy;
        this.typeRegistry = compiler.getTypeRegistry();
    }

    private static Node getBase(Node n) {
        Node base = n;
        while (base.isGetProp()) {
            base = base.getFirstChild();
        }
        return base;
    }

    private JSType getTypeOfThisForScope(NodeTraversal t) {
        JSType typeOfThis = t.getScopeRoot().getJSType();
        if (typeOfThis == null) {
            return null;
        }
        ObjectType objectType = ObjectType.cast(CheckEventfulObjectDisposal.dereference(typeOfThis));
        return objectType.getTypeOfThis();
    }

    private static boolean isPossiblySubtype(JSType thisType, JSType thatType) {
        if (thisType == null) {
            return false;
        }
        JSType type = thisType;
        if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                if (!alternate.isSubtype(thatType)) continue;
                return true;
            }
        } else if (type.isSubtype(thatType)) {
            return true;
        }
        return false;
    }

    private static JSType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    private static String generateKey(NodeTraversal t, Node n, boolean noLocalVariables) {
        String key;
        if (n == null) {
            return null;
        }
        Node scopeNode = t.getScopeRoot();
        if (n.isName()) {
            if (noLocalVariables) {
                return null;
            }
            key = n.getQualifiedName();
            if (scopeNode.isFunction()) {
                JSType parentScopeType = t.getScope().getParentScope().getTypeOfThis();
                if (!parentScopeType.isGlobalThisType()) {
                    key = parentScopeType.toString() + "~" + key;
                }
                key = NodeUtil.getFunctionName(scopeNode) + "=" + key;
            }
        } else {
            if (!n.isQualifiedName()) {
                return null;
            }
            key = n.getQualifiedName();
            Node base = CheckEventfulObjectDisposal.getBase(n);
            if (base != null && base.isThis()) {
                if (base.getJSType().isUnknownType()) {
                    key = t.getScope().getParentScope().getTypeOfThis().toString() + "~" + key;
                } else if (n.getFirstChild() == null) {
                    key = base.getJSType().toString() + "=" + key;
                } else {
                    ObjectType objectType = ObjectType.cast(CheckEventfulObjectDisposal.dereference(n.getFirstChild().getJSType()));
                    if (objectType == null) {
                        return null;
                    }
                    ObjectType hObjT = objectType;
                    String propertyName = n.getLastChild().getString();
                    while (objectType != null) {
                        hObjT = objectType;
                        if ((objectType = objectType.getImplicitPrototype()) != null && (objectType.getDisplayName().endsWith("prototype") || objectType.getPropertyNames().contains(propertyName))) continue;
                    }
                    key = hObjT.toString() + "=" + key;
                }
            }
        }
        return key;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((this.checkingPolicy != DisposalCheckingPolicy.OFF ? 1 : 0) != 0);
        this.googDisposableType = this.compiler.getTypeRegistry().getType(DISPOSABLE_TYPE_NAME);
        this.googEventsEventHandlerType = this.compiler.getTypeRegistry().getType(EVENT_HANDLER_TYPE_NAME);
        if (this.googEventsEventHandlerType == null || this.googDisposableType == null) {
            return;
        }
        this.eventfulTypes = new HashSet<JSType>();
        this.eventfulTypes.add(this.googEventsEventHandlerType);
        if (this.checkingPolicy == DisposalCheckingPolicy.AGGRESSIVE) {
            NodeTraversal.traverse(this.compiler, root, new ComputeEventizeTraversal());
            this.computeEventful();
        }
        eventfulObjectMap = new HashMap<String, EventfulObjectState>();
        NodeTraversal.traverse(this.compiler, root, new Traversal());
        for (EventfulObjectState e : eventfulObjectMap.values()) {
            Node n = e.allocationSite;
            if (e.seen == SeenType.ALLOCATED) {
                this.compiler.report(JSError.make(n.getSourceFileName(), n, EVENTFUL_OBJECT_NOT_DISPOSED, new String[0]));
                continue;
            }
            if (e.seen != SeenType.ALLOCATED_LOCALLY) continue;
            this.compiler.report(JSError.make(n.getSourceFileName(), n, EVENTFUL_OBJECT_PURELY_LOCAL, new String[0]));
        }
    }

    private void computeEventful() {
        String[] order = new String[this.eventizes.size()];
        int white = 0;
        int gray = 1;
        int black = 2;
        int last = this.eventizes.size() - 1;
        HashMap<String, Integer> color = new HashMap<String, Integer>();
        Stack<String> dfsStack = new Stack<String>();
        for (String r : this.eventizes.keySet()) {
            color.put(r, white);
            for (String s : this.eventizes.get(r)) {
                color.put(s, white);
            }
        }
        int indx = 0;
        for (String s : this.eventizes.keySet()) {
            dfsStack.push(s);
            while (dfsStack.size() > 0) {
                String top = (String)dfsStack.pop();
                if (!color.containsKey(top)) continue;
                if ((Integer)color.get(top) == white) {
                    color.put(top, gray);
                    dfsStack.push(top);
                    if (!this.eventizes.containsKey(top)) continue;
                    for (String v : this.eventizes.get(top)) {
                        if ((Integer)color.get(v) != white) continue;
                        dfsStack.push(v);
                    }
                    continue;
                }
                if ((Integer)color.get(top) != gray || !this.eventizes.containsKey(top)) continue;
                order[last - indx] = top;
                ++indx;
                color.put(top, black);
            }
        }
        for (String s : order) {
            if (!this.eventfulTypes.contains(this.typeRegistry.getType(s))) continue;
            for (String v : this.eventizes.get(s)) {
                this.eventfulTypes.add(this.typeRegistry.getType(v));
            }
        }
    }

    private JSType maybeReturnDisposedType(Node n, boolean checkDispose) {
        Node first = n.getFirstChild();
        if (first == null || !first.isQualifiedName()) {
            return null;
        }
        String property = first.getQualifiedName();
        if (property.endsWith(".registerDisposable")) {
            Node base = first.getFirstChild();
            JSType baseType = base.getJSType();
            if (baseType == null || !CheckEventfulObjectDisposal.isPossiblySubtype(baseType, this.googDisposableType)) {
                return null;
            }
            return n.getLastChild().getJSType();
        }
        if (checkDispose) {
            if (property.equals("goog.dispose")) {
                return n.getLastChild().getJSType();
            }
            if (property.endsWith(".dispose")) {
                return n.getFirstChild().getFirstChild().getJSType();
            }
        }
        return null;
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private Traversal() {
        }

        private boolean createsEventfulObject(Node n) {
            Node first = n.getFirstChild();
            JSType type = n.getJSType();
            if (first == null || !first.isQualifiedName() || type.isEmptyType() || type.isUnknownType()) {
                return false;
            }
            boolean isOfTypeNeedingDisposal = false;
            for (JSType disposableType : CheckEventfulObjectDisposal.this.eventfulTypes) {
                if (!type.isSubtype(disposableType)) continue;
                isOfTypeNeedingDisposal = true;
                break;
            }
            return isOfTypeNeedingDisposal;
        }

        private Node localEventfulObjectAssign(NodeTraversal t, Node propertyNode) {
            EventfulObjectState e;
            Node parent = !t.getScope().isGlobal() ? NodeUtil.getFunctionBody(t.getScopeRoot()) : t.getScopeRoot().getFirstChild();
            for (Node sibling : parent.children()) {
                Node assign;
                if (!sibling.isExprResult() || !(assign = sibling.getFirstChild()).isAssign() || !propertyNode.getQualifiedName().equals(assign.getLastChild().getQualifiedName()) || assign.getFirstChild().isName()) continue;
                return assign.getFirstChild();
            }
            String key = CheckEventfulObjectDisposal.generateKey(t, propertyNode, false);
            if (key == null) {
                return null;
            }
            if (eventfulObjectMap.containsKey(key)) {
                e = eventfulObjectMap.get(key);
                if (e.seen == SeenType.ALLOCATED) {
                    e.seen = SeenType.ALLOCATED_LOCALLY;
                }
            } else {
                e = new EventfulObjectState();
                e.seen = SeenType.ALLOCATED_LOCALLY;
                eventfulObjectMap.put(key, e);
            }
            e.allocationSite = propertyNode;
            return null;
        }

        private void isNew(NodeTraversal t, Node n, Node parent) {
            Node globalVarNode;
            EventfulObjectState e;
            if (!this.createsEventfulObject(n)) {
                return;
            }
            Node propertyNode = parent.isAssign() ? parent.getFirstChild() : parent;
            if (propertyNode.isName() && CheckEventfulObjectDisposal.this.checkingPolicy != DisposalCheckingPolicy.AGGRESSIVE) {
                return;
            }
            String key = CheckEventfulObjectDisposal.generateKey(t, propertyNode, false);
            if (key == null) {
                return;
            }
            if (eventfulObjectMap.containsKey(key)) {
                e = eventfulObjectMap.get(key);
            } else {
                e = new EventfulObjectState();
                e.seen = SeenType.ALLOCATED;
                eventfulObjectMap.put(key, e);
            }
            e.allocationSite = propertyNode;
            if (propertyNode.isName() && (globalVarNode = this.localEventfulObjectAssign(t, propertyNode)) != null) {
                key = CheckEventfulObjectDisposal.generateKey(t, globalVarNode, false);
                if (key == null) {
                    e.seen = SeenType.POSSIBLY_DISPOSED;
                    return;
                }
                eventfulObjectMap.put(key, e);
            }
        }

        private Node maybeGetValueNodeFromCall(Node n) {
            JSType possiblyArrayType;
            JSType calledOnType;
            Node first = n.getFirstChild();
            if (first == null || !first.isQualifiedName()) {
                return null;
            }
            String property = first.getQualifiedName();
            if (property.endsWith(".registerDisposable")) {
                Node base = first.getFirstChild();
                JSType baseType = base.getJSType();
                if (baseType == null || !CheckEventfulObjectDisposal.isPossiblySubtype(baseType, CheckEventfulObjectDisposal.this.googDisposableType)) {
                    return null;
                }
                return n.getLastChild();
            }
            if (property.equals("goog.dispose")) {
                return n.getLastChild();
            }
            Node calledOn = n.getFirstChild().getFirstChild();
            if (property.endsWith(".dispose")) {
                return calledOn;
            }
            if (property.endsWith(".removeAll") && calledOn != null && (calledOnType = calledOn.getJSType()) != null && !calledOnType.isEmptyType() && !calledOnType.isUnknownType() && CheckEventfulObjectDisposal.isPossiblySubtype(calledOnType, CheckEventfulObjectDisposal.this.googEventsEventHandlerType)) {
                return calledOn;
            }
            Node possiblyArray = first.getFirstChild();
            if (possiblyArray != null && (possiblyArrayType = possiblyArray.getJSType()) != null && possiblyArrayType.isArrayType()) {
                return n.getLastChild();
            }
            if (property.endsWith(".push") || property.contains(".add")) {
                return n.getLastChild();
            }
            return null;
        }

        private void isCall(NodeTraversal t, Node n) {
            Node variableNode = this.maybeGetValueNodeFromCall(n);
            if (variableNode == null) {
                return;
            }
            boolean isTrackedRemoval = false;
            JSType vnType = variableNode.getJSType();
            for (JSType type : CheckEventfulObjectDisposal.this.eventfulTypes) {
                if (!CheckEventfulObjectDisposal.isPossiblySubtype(vnType, type)) continue;
                isTrackedRemoval = true;
            }
            if (!isTrackedRemoval) {
                return;
            }
            String key = CheckEventfulObjectDisposal.generateKey(t, variableNode, false);
            if (key == null) {
                return;
            }
            this.eventfulObjectDisposed(t, variableNode);
        }

        private JSType dereference(JSType type) {
            return type == null ? null : type.dereference();
        }

        public void isAssign(NodeTraversal t, Node n) {
            Node assignedTo = n.getFirstChild();
            JSType assignedToType = assignedTo.getJSType();
            if (assignedToType == null || assignedToType.isEmptyType()) {
                return;
            }
            if (n.getFirstChild().isGetProp()) {
                boolean fieldIsPrivate;
                boolean isTrackedAssign = false;
                for (JSType disposalType : CheckEventfulObjectDisposal.this.eventfulTypes) {
                    if (!assignedToType.isSubtype(disposalType)) continue;
                    isTrackedAssign = true;
                    break;
                }
                if (!isTrackedAssign) {
                    return;
                }
                JSDocInfo di = n.getJSDocInfo();
                ObjectType objectType = ObjectType.cast(this.dereference(n.getFirstChild().getFirstChild().getJSType()));
                String propertyName = n.getFirstChild().getLastChild().getString();
                boolean bl = fieldIsPrivate = di != null && di.getVisibility() == JSDocInfo.Visibility.PRIVATE;
                while (objectType != null) {
                    di = null;
                    if ((objectType = objectType.getImplicitPrototype()) == null) break;
                    if (objectType.getDisplayName().endsWith("prototype") || (di = objectType.getOwnPropertyJSDocInfo(propertyName)) == null || !fieldIsPrivate && di.getVisibility() != JSDocInfo.Visibility.PRIVATE) continue;
                    CheckEventfulObjectDisposal.this.compiler.report(t.makeError(n, OVERWRITE_PRIVATE_EVENTFUL_OBJECT, new String[0]));
                    break;
                }
            }
        }

        private void isReturn(NodeTraversal t, Node n) {
            Node variableNode = n.getFirstChild();
            if (variableNode == null) {
                return;
            }
            JSType type = variableNode.getJSType();
            if (type == null || type.isEmptyType()) {
                return;
            }
            boolean isTrackedReturn = false;
            for (JSType disposalType : CheckEventfulObjectDisposal.this.eventfulTypes) {
                if (!type.isSubtype(disposalType)) continue;
                isTrackedReturn = true;
                break;
            }
            if (!isTrackedReturn) {
                return;
            }
            this.eventfulObjectDisposed(t, variableNode);
        }

        private void eventfulObjectDisposed(NodeTraversal t, Node variableNode) {
            String key = CheckEventfulObjectDisposal.generateKey(t, variableNode, false);
            if (key == null) {
                return;
            }
            EventfulObjectState e = eventfulObjectMap.get(key);
            if (e == null) {
                e = new EventfulObjectState();
                eventfulObjectMap.put(key, e);
            }
            e.seen = SeenType.POSSIBLY_DISPOSED;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
            LiveVariablesAnalysis liveness = new LiveVariablesAnalysis(cfg, t.getScope(), CheckEventfulObjectDisposal.this.compiler);
            liveness.analyze();
            for (Scope.Var v : liveness.getEscapedLocals()) {
                this.eventfulObjectDisposed(t, v.getNode());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 86: {
                    this.isAssign(t, n);
                    break;
                }
                case 37: {
                    this.isCall(t, n);
                    break;
                }
                case 30: {
                    this.isNew(t, n, parent);
                    break;
                }
                case 4: {
                    this.isReturn(t, n);
                    break;
                }
            }
        }
    }

    private class ComputeEventizeTraversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        Stack<Boolean> isConstructorStack = new Stack();
        Stack<Boolean> isDisposalStack = new Stack();

        public ComputeEventizeTraversal() {
            CheckEventfulObjectDisposal.this.eventizes = new HashMap<String, Set<String>>();
        }

        private Boolean inConstructorScope() {
            Preconditions.checkNotNull(this.isConstructorStack);
            if (this.isDisposalStack.size() > 0) {
                return this.isConstructorStack.peek();
            }
            return null;
        }

        private Boolean inDisposalScope() {
            Preconditions.checkNotNull(this.isDisposalStack);
            if (this.isDisposalStack.size() > 0) {
                return this.isDisposalStack.peek();
            }
            return null;
        }

        private boolean collectorFilterType(JSType type) {
            if (type == null) {
                return true;
            }
            return type.isEmptyType() || type.isUnknownType() || !CheckEventfulObjectDisposal.isPossiblySubtype(type, CheckEventfulObjectDisposal.this.googDisposableType);
        }

        private void addEventize(JSType thisType, JSType thatType) {
            if (this.collectorFilterType(thisType) || this.collectorFilterType(thatType) || thisType.isEquivalentTo(thatType)) {
                return;
            }
            String className = thisType.getDisplayName();
            if (thatType.isUnionType()) {
                UnionType ut = thatType.toMaybeUnionType();
                for (JSType type : ut.getAlternates()) {
                    if (!type.isObject()) continue;
                    this.addEventizeClass(className, type);
                }
            } else {
                this.addEventizeClass(className, thatType);
            }
        }

        private void addEventizeClass(String className, JSType thatType) {
            String propertyJsTypeName = thatType.getDisplayName();
            Set<String> eventize = CheckEventfulObjectDisposal.this.eventizes.get(propertyJsTypeName);
            if (eventize == null) {
                eventize = new HashSet<String>();
                CheckEventfulObjectDisposal.this.eventizes.put(propertyJsTypeName, eventize);
            }
            eventize.add(className);
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getScopeRoot();
            boolean isConstructor = false;
            boolean isInDisposal = false;
            String functionName = null;
            if (n.isFunction()) {
                functionName = NodeUtil.getFunctionName(n);
                if (functionName != null) {
                    JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(n);
                    if (jsDocInfo != null && jsDocInfo.isConstructor()) {
                        isConstructor = true;
                        if (t.getScope() != null && t.getScope().getTypeOfThis() != null) {
                            ObjectType objectType = ObjectType.cast(t.getScope().getTypeOfThis().dereference());
                            while (objectType != null && (objectType = objectType.getImplicitPrototype()) != null) {
                                if (objectType.getDisplayName().endsWith("prototype")) continue;
                                this.addEventize(CheckEventfulObjectDisposal.this.compiler.getTypeRegistry().getType(functionName), objectType);
                                break;
                            }
                        }
                    }
                    if (functionName.endsWith(".disposeInternal")) {
                        isInDisposal = true;
                    }
                }
                this.isConstructorStack.push(isConstructor);
                this.isDisposalStack.push(isInDisposal);
            } else {
                this.isConstructorStack.push(this.inConstructorScope());
                this.isDisposalStack.push(this.inDisposalScope());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.isConstructorStack.pop();
            this.isDisposalStack.pop();
        }

        private void isGoogEventsUnlisten(Node n) {
            Preconditions.checkArgument((n.getChildCount() > 3 ? 1 : 0) != 0);
            Node listener = n.getChildAtIndex(3);
            Node objectWithListener = n.getChildAtIndex(1);
            if (!objectWithListener.isQualifiedName()) {
                return;
            }
            if (listener.isFunction()) {
                CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n.getSourceFileName(), n, UNLISTEN_WITH_ANONBOUND, new String[0]));
            } else if (listener.isCall()) {
                if (!listener.getFirstChild().isQualifiedName()) {
                    CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n.getSourceFileName(), n, UNLISTEN_WITH_ANONBOUND, new String[0]));
                } else if (listener.getFirstChild().getQualifiedName().equals("goog.bind")) {
                    CheckEventfulObjectDisposal.this.compiler.report(JSError.make(n.getSourceFileName(), n, UNLISTEN_WITH_ANONBOUND, new String[0]));
                }
            }
        }

        private void isCalled(NodeTraversal t, Node n) {
            JSType disposedType;
            Node functionCalled = n.getFirstChild();
            if (functionCalled == null || !functionCalled.isQualifiedName()) {
                return;
            }
            String functionCalledName = functionCalled.getQualifiedName();
            JSType typeOfThis = CheckEventfulObjectDisposal.this.getTypeOfThisForScope(t);
            if (typeOfThis == null) {
                return;
            }
            if (functionCalledName.equals("goog.events.unlisten")) {
                if (this.inDisposalScope().booleanValue()) {
                    CheckEventfulObjectDisposal.this.eventfulTypes.add(typeOfThis);
                }
                this.isGoogEventsUnlisten(n);
            }
            if (this.inDisposalScope().booleanValue() && functionCalledName.equals("goog.events.removeAll")) {
                CheckEventfulObjectDisposal.this.eventfulTypes.add(typeOfThis);
            }
            if (!this.collectorFilterType(disposedType = CheckEventfulObjectDisposal.this.maybeReturnDisposedType(n, this.inDisposalScope()))) {
                this.addEventize(CheckEventfulObjectDisposal.this.getTypeOfThisForScope(t), disposedType);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    this.isCalled(t, n);
                    break;
                }
            }
        }
    }

    private class EventfulObjectState {
        public SeenType seen;
        public Node allocationSite;

        private EventfulObjectState() {
        }
    }

    private static enum SeenType {
        ALLOCATED,
        ALLOCATED_LOCALLY,
        POSSIBLY_DISPOSED,
        DISPOSED;

    }

    public static enum DisposalCheckingPolicy {
        OFF,
        ON,
        AGGRESSIVE;

    }
}

