/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Set;

class RemoveUnusedClassProperties
implements CompilerPass,
NodeTraversal.Callback {
    final AbstractCompiler compiler;
    private boolean inExterns;
    private Set<String> used = Sets.newHashSet();
    private List<Node> candidates = Lists.newArrayList();

    RemoveUnusedClassProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        this.removeUnused();
    }

    private void removeUnused() {
        for (Node n : this.candidates) {
            Preconditions.checkState((boolean)n.isGetProp());
            if (this.used.contains(n.getLastChild().getString())) continue;
            Node parent = n.getParent();
            if (NodeUtil.isAssignmentOp(parent)) {
                Node assign = parent;
                Preconditions.checkState((assign != null && NodeUtil.isAssignmentOp(assign) && assign.getFirstChild() == n ? 1 : 0) != 0);
                assign.getParent().replaceChild(assign, assign.getLastChild().detachFromParent());
            } else if (parent.isInc() || parent.isDec()) {
                parent.getParent().replaceChild(parent, IR.number(0.0));
            } else {
                throw new IllegalStateException("unexpected: " + parent);
            }
            this.compiler.reportCodeChange();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.inExterns = n.getStaticSourceFile().isExtern();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: {
                String propName = n.getLastChild().getString();
                if (this.inExterns || this.isPinningPropertyUse(n)) {
                    this.used.add(propName);
                    break;
                }
                if (!n.getFirstChild().isThis()) break;
                this.candidates.add(n);
                break;
            }
            case 37: {
                Node propName;
                Node target = n.getFirstChild();
                if (!n.hasMoreThanOneChild() || !target.isName() || !target.getString().equals("JSCompiler_renameProperty") || !(propName = target.getNext()).isString()) break;
                this.used.add(propName.getString());
            }
        }
    }

    private boolean isPinningPropertyUse(Node n) {
        Node parent = n.getParent();
        if (n == parent.getFirstChild()) {
            if (parent.isAssign()) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec()) {
                return NodeUtil.isExpressionResultUsed(parent);
            }
        }
        return true;
    }
}

