/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;

public class NoObjectType
extends FunctionType {
    private static final long serialVersionUID = 1L;
    private final Visitor<JSType> leastSupertypeVisitor = new LeastSupertypeVisitor();
    private final Visitor<JSType> greatestSubtypeVisitor = new GreatestSupertypeVisitor();

    NoObjectType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry, null, null, jSTypeRegistry.createArrowType(null, null), null, null, true, true);
        this.getInternalArrowType().returnType = this;
        this.setInstanceType(this);
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        return jSType.isEmptyType() ? TernaryValue.TRUE : TernaryValue.UNKNOWN;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        return jSType.isObject() && !jSType.isNoType();
    }

    @Override
    public boolean isFunctionType() {
        return false;
    }

    @Override
    public boolean isNoObjectType() {
        return true;
    }

    @Override
    public JSType getLeastSupertype(JSType jSType) {
        return jSType.visit(this.leastSupertypeVisitor);
    }

    @Override
    public JSType getGreatestSubtype(JSType jSType) {
        return jSType.visit(this.greatestSubtypeVisitor);
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public String getReferenceName() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        return this == jSType;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int getPropertiesCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public JSType getPropertyType(String string) {
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public boolean hasProperty(String string) {
        return true;
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        return true;
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String string) {
        return null;
    }

    @Override
    public void setPropertyJSDocInfo(String string, JSDocInfo jSDocInfo, boolean bl) {
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        return false;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNoObjectType();
    }

    @Override
    public String toString() {
        return "NoObject";
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        return this;
    }

    private class GreatestSupertypeVisitor
    implements Visitor<JSType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private GreatestSupertypeVisitor() {
        }

        @Override
        public JSType caseNoObjectType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseUnknownType() {
            return NoObjectType.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseNullType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseStringType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            JSType jSType = NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
            if (jSType.isSubtype(unionType)) {
                return jSType;
            }
            if (unionType.isSubtype(jSType)) {
                return unionType;
            }
            return NoObjectType.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseAllType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            return enumElementType.getPrimitiveType().visit(this);
        }
    }

    private class LeastSupertypeVisitor
    implements Visitor<JSType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LeastSupertypeVisitor() {
        }

        @Override
        public JSType caseNoObjectType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseUnknownType() {
            return NoObjectType.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return NoObjectType.this.registry.createUnionType(JSTypeNative.NO_OBJECT_TYPE, JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType functionType) {
            return functionType;
        }

        @Override
        public JSType caseNullType() {
            return NoObjectType.this.registry.createUnionType(JSTypeNative.NO_OBJECT_TYPE, JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return NoObjectType.this.registry.createUnionType(JSTypeNative.NO_OBJECT_TYPE, JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType objectType) {
            return objectType;
        }

        @Override
        public JSType caseStringType() {
            return NoObjectType.this.registry.createUnionType(JSTypeNative.NO_OBJECT_TYPE, JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType unionType) {
            return NoObjectType.this.registry.createUnionType(NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE), unionType);
        }

        @Override
        public JSType caseAllType() {
            return NoObjectType.this.getNativeType(JSTypeNative.ALL_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return NoObjectType.this.registry.createUnionType(JSTypeNative.NO_OBJECT_TYPE, JSTypeNative.VOID_TYPE);
        }

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType jSType = enumElementType.getPrimitiveType();
            return jSType.isObject() ? jSType : NoObjectType.this.registry.createUnionType(NoObjectType.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE), enumElementType);
        }
    }
}

