/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.Maps;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class RecordType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private SortedMap<String, JSType> properties = Maps.newTreeMap();
    private boolean isFrozen = false;

    RecordType(JSTypeRegistry jSTypeRegistry, Map<String, JSType> map) {
        super(jSTypeRegistry, null, null);
        for (String string : map.keySet()) {
            this.defineDeclaredProperty(string, map.get(string), false);
        }
        this.isFrozen = true;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (!(jSType instanceof RecordType)) {
            return false;
        }
        RecordType recordType = (RecordType)jSType;
        Set<String> set = this.properties.keySet();
        SortedMap<String, JSType> sortedMap = recordType.properties;
        if (!((Object)sortedMap.keySet()).equals(set)) {
            return false;
        }
        for (String string : set) {
            if (((JSType)sortedMap.get(string)).isEquivalentTo((JSType)this.properties.get(string))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2) {
        if (this.isFrozen) {
            return false;
        }
        if (!bl) {
            this.properties.put(string, jSType);
        }
        return super.defineProperty(string, jSType, bl, bl2);
    }

    @Override
    public JSType getLeastSupertype(JSType jSType) {
        if (!jSType.isRecordType()) {
            return super.getLeastSupertype(jSType);
        }
        RecordType recordType = (RecordType)jSType;
        RecordTypeBuilder recordTypeBuilder = new RecordTypeBuilder(this.registry);
        for (String string : this.properties.keySet()) {
            if (!recordType.hasProperty(string) || !recordType.getPropertyType(string).isEquivalentTo(this.getPropertyType(string))) continue;
            recordTypeBuilder.addProperty(string, this.getPropertyType(string));
        }
        return recordTypeBuilder.build();
    }

    @Override
    public JSType getGreatestSubtype(JSType jSType) {
        if (jSType.isRecordType()) {
            RecordType recordType = (RecordType)jSType;
            RecordTypeBuilder recordTypeBuilder = new RecordTypeBuilder(this.registry);
            for (String string : this.properties.keySet()) {
                if (recordType.hasProperty(string) && !recordType.getPropertyType(string).isEquivalentTo(this.getPropertyType(string))) {
                    return this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
                }
                recordTypeBuilder.addProperty(string, this.getPropertyType(string));
            }
            for (String string : recordType.properties.keySet()) {
                if (this.hasProperty(string)) continue;
                recordTypeBuilder.addProperty(string, recordType.getPropertyType(string));
            }
            return recordTypeBuilder.build();
        }
        JSType jSType2 = super.getGreatestSubtype(jSType);
        if (jSType2.isNoObjectType() && !jSType.isNoObjectType()) {
            for (Map.Entry<String, JSType> entry : this.properties.entrySet()) {
                String string = entry.getKey();
                JSType jSType3 = entry.getValue();
                UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(this.registry);
                for (ObjectType objectType : this.registry.getTypesWithProperty(string)) {
                    JSType jSType4 = objectType.getPropertyType(string);
                    if (jSType4 == null || objectType.isEquivalentTo(this) || !objectType.isSubtype(jSType) || !jSType3.isUnknownType() && !jSType4.isUnknownType() && !jSType4.isEquivalentTo(jSType3)) continue;
                    unionTypeBuilder.addAlternate(objectType);
                }
                jSType2 = jSType2.getLeastSupertype(unionTypeBuilder.build());
            }
        }
        return jSType2;
    }

    @Override
    public boolean isRecordType() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        if (this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE).isSubtype(jSType)) {
            return true;
        }
        if (!jSType.isRecordType()) {
            return false;
        }
        return RecordType.isSubtype(this, (RecordType)jSType);
    }

    static boolean isSubtype(ObjectType objectType, RecordType recordType) {
        for (String string : recordType.properties.keySet()) {
            if (!objectType.hasProperty(string)) {
                return false;
            }
            JSType jSType = objectType.getPropertyType(string);
            JSType jSType2 = recordType.getPropertyType(string);
            if (jSType.isUnknownType() || jSType2.isUnknownType() || !(objectType.isPropertyTypeDeclared(string) ? !jSType.isEquivalentTo(jSType2) : !jSType.isSubtype(jSType2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        int n = 0;
        for (String string : this.properties.keySet()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" : ");
            stringBuilder.append(((JSType)this.properties.get(string)).toString());
            ++n;
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        for (Map.Entry<String, JSType> entry : this.properties.entrySet()) {
            JSType jSType;
            JSType jSType2 = entry.getValue();
            if (jSType2 == (jSType = jSType2.resolve(errorReporter, staticScope))) continue;
            this.properties.put(entry.getKey(), jSType);
        }
        return super.resolveInternal(errorReporter, staticScope);
    }
}

