/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.Set;

class ProxyObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private JSType referencedType;
    private ObjectType referencedObjType;

    ProxyObjectType(JSTypeRegistry jSTypeRegistry, JSType jSType) {
        super(jSTypeRegistry);
        this.setReferencedType(jSType);
    }

    JSType getReferencedTypeInternal() {
        return this.referencedType;
    }

    void setReferencedType(JSType jSType) {
        this.referencedType = jSType;
        this.referencedObjType = jSType instanceof ObjectType ? (ObjectType)jSType : null;
    }

    @Override
    public String getReferenceName() {
        return this.referencedObjType == null ? "" : this.referencedObjType.getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.referencedObjType == null ? null : Boolean.valueOf(this.referencedObjType.hasReferenceName());
    }

    @Override
    public boolean matchesNumberContext() {
        return this.referencedType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.referencedType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.referencedType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.referencedType.canBeCalled();
    }

    @Override
    public boolean isUnknownType() {
        return this.referencedType.isUnknownType();
    }

    @Override
    public boolean isCheckedUnknownType() {
        return this.referencedType.isCheckedUnknownType();
    }

    @Override
    public boolean isNullable() {
        return this.referencedType.isNullable();
    }

    @Override
    public boolean isFunctionPrototypeType() {
        return this.referencedType.isFunctionPrototypeType();
    }

    @Override
    public boolean isEnumType() {
        return this.referencedType.isEnumType();
    }

    @Override
    public boolean isEnumElementType() {
        return this.referencedType.isEnumElementType();
    }

    @Override
    public boolean isConstructor() {
        return this.referencedType.isConstructor();
    }

    @Override
    public boolean isNominalType() {
        return this.referencedType.isNominalType();
    }

    @Override
    public boolean isInstanceType() {
        return this.referencedType.isInstanceType();
    }

    @Override
    public boolean isInterface() {
        return this.referencedType.isInterface();
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.referencedType.isOrdinaryFunction();
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        return this.referencedType.testForEquality(jSType);
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        return this.referencedType.isSubtype(jSType);
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.referencedObjType == null ? Collections.emptyList() : this.referencedObjType.getCtorImplementedInterfaces();
    }

    @Override
    public boolean canAssignTo(JSType jSType) {
        return this.referencedType.canAssignTo(jSType);
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (this == jSType) {
            return true;
        }
        return this.referencedType.isEquivalentTo(jSType);
    }

    @Override
    public int hashCode() {
        return this.referencedType.hashCode();
    }

    public String toString() {
        return this.referencedType.toString();
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.referencedObjType == null ? null : this.referencedObjType.getImplicitPrototype();
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2) {
        return this.referencedObjType == null ? true : this.referencedObjType.defineProperty(string, jSType, bl, bl2);
    }

    @Override
    public boolean isPropertyTypeDeclared(String string) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyTypeDeclared(string);
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyTypeInferred(string);
    }

    @Override
    public boolean isPropertyInExterns(String string) {
        return this.referencedObjType == null ? false : this.referencedObjType.isPropertyInExterns(string);
    }

    @Override
    public int getPropertiesCount() {
        return this.referencedObjType == null ? 0 : this.referencedObjType.getPropertiesCount();
    }

    @Override
    protected void collectPropertyNames(Set<String> set) {
        if (this.referencedObjType != null) {
            this.referencedObjType.collectPropertyNames(set);
        }
    }

    @Override
    public JSType findPropertyType(String string) {
        return this.referencedType.findPropertyType(string);
    }

    @Override
    public JSType getPropertyType(String string) {
        return this.referencedObjType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : this.referencedObjType.getPropertyType(string);
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.referencedType.getJSDocInfo();
    }

    @Override
    public void setJSDocInfo(JSDocInfo jSDocInfo) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setJSDocInfo(jSDocInfo);
        }
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String string) {
        return this.referencedObjType == null ? null : this.referencedObjType.getOwnPropertyJSDocInfo(string);
    }

    @Override
    public void setPropertyJSDocInfo(String string, JSDocInfo jSDocInfo, boolean bl) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setPropertyJSDocInfo(string, jSDocInfo, bl);
        }
    }

    @Override
    public boolean hasProperty(String string) {
        return this.referencedObjType == null ? false : this.referencedObjType.hasProperty(string);
    }

    @Override
    public boolean hasOwnProperty(String string) {
        return this.referencedObjType == null ? false : this.referencedObjType.hasOwnProperty(string);
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        return this.referencedObjType == null ? ImmutableSet.of() : this.referencedObjType.getOwnPropertyNames();
    }

    @Override
    public FunctionType getConstructor() {
        return this.referencedObjType == null ? null : this.referencedObjType.getConstructor();
    }

    @Override
    public JSType getParameterType() {
        return this.referencedObjType == null ? null : this.referencedObjType.getParameterType();
    }

    @Override
    public JSType getIndexType() {
        return this.referencedObjType == null ? null : this.referencedObjType.getIndexType();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return this.referencedType.visit(visitor);
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.setReferencedType(this.referencedType.resolve(errorReporter, staticScope));
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        return "{proxy:" + this.referencedType.toDebugHashCodeString() + "}";
    }
}

