/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.EvaluatorException;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.ObjArray;
import com.google.javascript.rhino.ObjToIntMap;
import com.google.javascript.rhino.ScriptRuntime;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;

public class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    public static final int FEATURE_PARENT_PROTO_PROPRTIES = 5;
    public static final int FEATURE_E4X = 6;
    public static final int FEATURE_DYNAMIC_SCOPE = 7;
    public static final int FEATURE_STRICT_VARS = 8;
    public static final int FEATURE_STRICT_EVAL = 9;
    public static final int FEATURE_LOCATION_INFORMATION_IN_ERROR = 10;
    public static final int FEATURE_STRICT_MODE = 11;
    public static final int FEATURE_WARNING_AS_ERROR = 12;
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final Object[] emptyArgs = ScriptRuntime.emptyArgs;
    private static ThreadLocal<Context> threadContexts = new ThreadLocal();
    private static String implementationVersion;
    private boolean sealed;
    private Object sealKey;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    private ErrorReporter errorReporter;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    boolean compileFunctionsWithDynamicScopeFlag;
    boolean useDynamicScope;
    private Object debuggerData;
    private int enterCount;
    private int optimizationLevel;
    private Object propertyListeners;
    private Hashtable<Object, Object> hashtable;
    Hashtable<Object, Object> activationNames;
    Object lastInterpreterFrame;
    ObjArray previousInterpreterInvocations;
    int instructionCount;
    int instructionThreshold;
    int scratchIndex;
    long scratchUint32;

    public Context() {
        this.setLanguageVersion(0);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        Context context2 = Context.getCurrentContext();
        if (context == null) {
            if (context2 != null) {
                context = context2;
            } else {
                context = new Context();
                Context.setThreadContext(context);
            }
        } else if (context.enterCount != 0) {
            if (context != context2) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (context2 != null) {
            context = context2;
        } else {
            Context.setThreadContext(context);
        }
        ++context.enterCount;
        return context;
    }

    public static void exit() {
        boolean bl = false;
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (context.enterCount < 1) {
            Kit.codeBug();
        }
        --context.enterCount;
        if (context.enterCount == 0) {
            bl = true;
            Context.setThreadContext(null);
        }
    }

    public static Context getCurrentContext() {
        return threadContexts.get();
    }

    private static void setThreadContext(Context context) {
        threadContexts.set(context);
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = object;
    }

    public final void unseal(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.sealKey != object) {
            throw new IllegalArgumentException();
        }
        if (!this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = false;
        this.sealKey = null;
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(n);
        Object object = this.propertyListeners;
        if (object != null && n != this.version) {
            this.firePropertyChangeImpl(object, languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public static boolean isValidLanguageVersion(int n) {
        switch (n) {
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 160: {
                return true;
            }
        }
        return false;
    }

    public static void checkLanguageVersion(int n) {
        if (Context.isValidLanguageVersion(n)) {
            return;
        }
        throw new IllegalArgumentException("Bad language version: " + n);
    }

    public final String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = ScriptRuntime.getMessage0("implementation.version");
        }
        return implementationVersion;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        ErrorReporter errorReporter2 = this.getErrorReporter();
        if (errorReporter == errorReporter2) {
            return errorReporter2;
        }
        Object object = this.propertyListeners;
        if (object != null) {
            this.firePropertyChangeImpl(object, errorReporterProperty, errorReporter2, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final Locale setLocale(Locale locale) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, propertyChangeListener);
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        Object object3 = this.propertyListeners;
        if (object3 != null) {
            this.firePropertyChangeImpl(object3, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object object, String string, Object object2, Object object3) {
        Object object4;
        int n = 0;
        while ((object4 = Kit.getListener(object, n)) != null) {
            if (object4 instanceof PropertyChangeListener) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object4;
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object2, object3));
            }
            ++n;
        }
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new EvaluatorException(string, string2, n, string3, n2);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static void reportError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string, string2, n, string3, n2);
    }

    static EvaluatorException reportRuntimeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError1(String string, Object object) {
        String string2 = ScriptRuntime.getMessage1(string, object);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        String string2 = ScriptRuntime.getMessage2(string, object, object2);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        String string2 = ScriptRuntime.getMessage3(string, object, object2, object3);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError4(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = ScriptRuntime.getMessage4(string, object, object2, object3, object4);
        return Context.reportRuntimeError(string2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final void setGeneratingSource(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public static boolean isValidOptimizationLevel(int n) {
        return -1 <= n && n <= 9;
    }

    public static void checkOptimizationLevel(int n) {
        if (Context.isValidOptimizationLevel(n)) {
            return;
        }
        throw new IllegalArgumentException("Optimization level outside [-1..9]: " + n);
    }

    public final Object getThreadLocal(Object object) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(object);
    }

    public final void putThreadLocal(Object object, Object object2) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, object2);
    }

    public final void removeThreadLocal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(object);
    }

    @Deprecated
    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    @Deprecated
    public final void setCompileFunctionsWithDynamicScope(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    protected boolean hasFeature(int n) {
        switch (n) {
            case 1: {
                int n2 = this.getLanguageVersion();
                return n2 == 100 || n2 == 110 || n2 == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                int n3 = this.getLanguageVersion();
                return n3 == 120;
            }
            case 5: {
                return true;
            }
            case 6: {
                int n4 = this.getLanguageVersion();
                return n4 == 0 || n4 >= 160;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.instructionThreshold = n;
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                n3 = i;
                continue;
            }
            if (c == '(') {
                n = i;
                continue;
            }
            if (c == ')') {
                n2 = i;
                continue;
            }
            if (c != '\n' || n == -1 || n2 == -1 || n3 == -1 || n >= n3 || n3 >= n2) continue;
            String string2 = string.substring(n + 1, n3);
            if (!string2.endsWith(".java")) {
                String string3 = string.substring(n3 + 1, n2);
                try {
                    nArray[0] = Integer.parseInt(string3);
                    if (nArray[0] < 0) {
                        nArray[0] = 0;
                    }
                    return string2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            n3 = -1;
            n2 = -1;
            n = -1;
        }
        return null;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(string, string);
    }

    public final boolean isActivationNeeded(String string) {
        return this.activationNames != null && this.activationNames.containsKey(string);
    }

    public void removeActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }
}

