/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.Iterator;
import java.util.ListIterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonMLUtil {
    public static boolean isExpression(JsonML jsonML) {
        switch (jsonML.getType()) {
            case ArrayExpr: 
            case AssignExpr: 
            case BinaryExpr: 
            case CallExpr: 
            case ConditionalExpr: 
            case CountExpr: 
            case DeleteExpr: 
            case EvalExpr: 
            case FunctionExpr: 
            case IdExpr: 
            case InvokeExpr: 
            case LiteralExpr: 
            case LogicalAndExpr: 
            case LogicalOrExpr: 
            case MemberExpr: 
            case NewExpr: 
            case ObjectExpr: 
            case RegExpExpr: 
            case ThisExpr: 
            case TypeofExpr: 
            case UnaryExpr: {
                return true;
            }
        }
        return false;
    }

    public static JsonML parseString(String string) throws Exception {
        return JsonMLUtil.parseElement(new JSONArray(string));
    }

    private static JsonML parseElement(JSONArray jSONArray) throws Exception {
        JsonML jsonML = new JsonML(TagType.valueOf(jSONArray.getString(0)));
        JSONObject jSONObject = jSONArray.getJSONObject(1);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = jSONObject.get(string);
            TagAttr tagAttr = TagAttr.get(string);
            if (tagAttr == null) continue;
            if (object instanceof Number) {
                object = ((Number)object).doubleValue();
            }
            switch (tagAttr) {
                case NAME: 
                case BODY: 
                case FLAGS: 
                case OP: 
                case TYPE: 
                case IS_PREFIX: 
                case LABEL: {
                    jsonML.setAttribute(tagAttr, object);
                    break;
                }
                case VALUE: {
                    if (object != null && object.equals(null)) {
                        object = null;
                    }
                    if (object instanceof Number) {
                        jsonML.setAttribute(tagAttr, ((Number)object).doubleValue());
                        break;
                    }
                    jsonML.setAttribute(tagAttr, object);
                    break;
                }
            }
        }
        for (int i = 2; i < jSONArray.length(); ++i) {
            jsonML.appendChild(JsonMLUtil.parseElement(jSONArray.getJSONArray(i)));
        }
        return jsonML;
    }

    public static String compare(JsonML jsonML, JsonML jsonML2) {
        return new JsonMLComparator(jsonML, jsonML2).compare();
    }

    static boolean compareSilent(JsonML jsonML, JsonML jsonML2) {
        return new JsonMLComparator(jsonML, jsonML2).compareSilent();
    }

    private static class JsonMLComparator {
        private static final TagAttr[] ATTRS_TO_COMPARE = new TagAttr[]{TagAttr.BODY, TagAttr.FLAGS, TagAttr.IS_PREFIX, TagAttr.LABEL, TagAttr.NAME, TagAttr.OP, TagAttr.TYPE, TagAttr.VALUE};
        private JsonML treeA;
        private JsonML treeB;
        private JsonML mismatchA;
        private JsonML mismatchB;

        JsonMLComparator(JsonML jsonML, JsonML jsonML2) {
            this.treeA = jsonML;
            this.treeB = jsonML2;
            if (this.compareElements(jsonML, jsonML2)) {
                this.mismatchA = null;
                this.mismatchB = null;
            }
        }

        private boolean setMismatch(JsonML jsonML, JsonML jsonML2) {
            this.mismatchA = jsonML;
            this.mismatchB = jsonML2;
            return false;
        }

        private boolean compareElements(JsonML jsonML, JsonML jsonML2) {
            if (jsonML == null || jsonML2 == null) {
                if (jsonML == null && jsonML2 == null) {
                    return true;
                }
                return this.setMismatch(jsonML, jsonML2);
            }
            if (!this.areEquivalent(jsonML, jsonML2)) {
                return this.setMismatch(jsonML, jsonML2);
            }
            if (jsonML.childrenSize() != jsonML2.childrenSize()) {
                return this.setMismatch(jsonML, jsonML2);
            }
            ListIterator<JsonML> listIterator = jsonML.getChildren().listIterator();
            ListIterator<JsonML> listIterator2 = jsonML2.getChildren().listIterator();
            while (listIterator.hasNext()) {
                if (this.compareElements((JsonML)listIterator.next(), (JsonML)listIterator2.next())) continue;
                return false;
            }
            return true;
        }

        private boolean areEquivalent(JsonML jsonML, JsonML jsonML2) {
            if (jsonML.getType() != jsonML2.getType()) {
                return false;
            }
            for (TagAttr tagAttr : ATTRS_TO_COMPARE) {
                if (this.compareAttribute(tagAttr, jsonML, jsonML2)) continue;
                return false;
            }
            return true;
        }

        private boolean compareAttribute(TagAttr tagAttr, JsonML jsonML, JsonML jsonML2) {
            Object object = jsonML.getAttributes().get((Object)tagAttr);
            Object object2 = jsonML2.getAttributes().get((Object)tagAttr);
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null || object2 == null) {
                return false;
            }
            if (!object.equals(object2)) {
                Double d = null;
                Double d2 = null;
                if (object instanceof Number) {
                    d = ((Number)object).doubleValue();
                } else if (object instanceof String) {
                    d = Double.valueOf((String)object);
                } else {
                    return false;
                }
                if (object2 instanceof Number) {
                    d2 = ((Number)object2).doubleValue();
                } else if (object2 instanceof String) {
                    d2 = Double.valueOf((String)object2);
                } else {
                    return false;
                }
                if (!d.equals(d2)) {
                    return false;
                }
            }
            return true;
        }

        private boolean compareSilent() {
            return this.mismatchA == null && this.mismatchB == null;
        }

        private String compare() {
            if (this.compareSilent()) {
                return null;
            }
            return "The trees are not equal: \n\nTree1:\n " + this.treeA.toStringTree() + "\n\nTree2:\n " + this.treeB.toStringTree() + "\n\nSubtree1:\n " + this.mismatchA.toStringTree() + "\n\nSubtree2:\n " + this.mismatchB.toStringTree();
        }
    }
}

