/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.JsonMLException;
import com.google.javascript.jscomp.jsonml.Reader;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.Writer;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;

public class JsonMLAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SOURCE_NAME = "[[jsonmlsource]]";
    private JsonML jsonml;
    private Node root;

    public JsonMLAst(JsonML jsonML) {
        this.jsonml = jsonML;
    }

    @Override
    public void clearAst() {
        this.root = null;
    }

    @Override
    public Node getAstRoot(AbstractCompiler abstractCompiler) {
        if (this.root == null) {
            this.createAst(abstractCompiler);
        }
        return this.root;
    }

    @Override
    public SourceFile getSourceFile() {
        return null;
    }

    @Override
    public void setSourceFile(SourceFile sourceFile) {
        throw new UnsupportedOperationException("JsonMLAst cannot be associated with a SourceFile instance.");
    }

    public String getSourceName() {
        Object object = this.jsonml.getAttribute(TagAttr.SOURCE);
        if (object instanceof String) {
            return (String)object;
        }
        return DEFAULT_SOURCE_NAME;
    }

    private void createAst(AbstractCompiler abstractCompiler) {
        Reader reader = new Reader();
        reader.setRootElement(this.jsonml);
        try {
            this.root = reader.parse(abstractCompiler);
        }
        catch (JsonMLException jsonMLException) {
            // empty catch block
        }
    }

    public JsonML convertToJsonML() {
        if (this.root != null) {
            Writer writer = new Writer();
            return writer.processAst(this.root);
        }
        return null;
    }

    public JsonML getElementPreOrder(int n) {
        Preconditions.checkState((this.jsonml != null ? 1 : 0) != 0);
        if (n == 0) {
            return this.jsonml;
        }
        ArrayDeque<WalkHelper> arrayDeque = new ArrayDeque<WalkHelper>();
        arrayDeque.push(new WalkHelper(this.jsonml, 0));
        int n2 = 0;
        while (n2 <= n && !arrayDeque.isEmpty()) {
            WalkHelper walkHelper = (WalkHelper)arrayDeque.pop();
            JsonML jsonML = walkHelper.element;
            Integer n3 = walkHelper.childno;
            if (n3 >= jsonML.childrenSize()) continue;
            arrayDeque.push(new WalkHelper(jsonML, n3 + 1));
            jsonML = jsonML.getChild(n3);
            if (++n2 == n) {
                return jsonML;
            }
            arrayDeque.push(new WalkHelper(jsonML, 0));
        }
        return null;
    }

    private static class WalkHelper {
        final JsonML element;
        final int childno;

        WalkHelper(JsonML jsonML, int n) {
            this.element = jsonML;
            this.childno = n;
        }
    }
}

