/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class JsonML {
    private final TagType type;
    private Map<TagAttr, Object> attributes = new EnumMap<TagAttr, Object>(TagAttr.class);
    private List<JsonML> children = new ArrayList<JsonML>();

    public JsonML(TagType tagType) {
        this.type = tagType;
    }

    public JsonML(TagType tagType, JsonML ... jsonMLArray) {
        this(tagType, Arrays.asList(jsonMLArray));
    }

    public JsonML(TagType tagType, List<? extends JsonML> list) {
        this(tagType, Collections.emptyMap(), list);
    }

    public JsonML(TagType tagType, Map<? extends TagAttr, ?> map) {
        this(tagType, map, Collections.emptyList());
    }

    public JsonML(TagType tagType, Map<? extends TagAttr, ?> map, List<? extends JsonML> list) {
        this.type = tagType;
        this.attributes.putAll(map);
        this.appendChildren(list);
    }

    public void addChild(int n, JsonML jsonML) {
        this.children.add(n, jsonML);
    }

    public void appendChild(JsonML jsonML) {
        this.children.add(jsonML);
    }

    public void appendChildren(Collection<? extends JsonML> collection) {
        this.children.addAll(collection);
    }

    public int childrenSize() {
        return this.children.size();
    }

    public void clearChildren() {
        this.setChildren(new JsonML[0]);
    }

    public Object getAttribute(TagAttr tagAttr) {
        return this.attributes.get((Object)tagAttr);
    }

    public Map<TagAttr, Object> getAttributes() {
        return this.attributes;
    }

    public JsonML getChild(int n) {
        return this.children.get(n);
    }

    public List<JsonML> getChildren() {
        return this.children;
    }

    public List<JsonML> getChildren(int n, int n2) {
        return this.children.subList(n, n2);
    }

    public TagType getType() {
        return this.type;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setAttribute(TagAttr tagAttr, Object object) {
        this.attributes.put(tagAttr, object);
    }

    public void setAttributes(Map<TagAttr, Object> map) {
        this.attributes = map;
    }

    public void setChild(int n, JsonML jsonML) {
        this.children.set(n, jsonML);
    }

    public void setChildren(JsonML ... jsonMLArray) {
        this.children.clear();
        for (JsonML jsonML : jsonMLArray) {
            this.children.add(jsonML);
        }
    }

    public void setChildren(List<JsonML> list) {
        this.children = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true, true);
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        stringBuilder.append("[\"");
        JsonML.escapeStringOnto(this.type.name(), stringBuilder);
        stringBuilder.append('\"');
        if (bl) {
            stringBuilder.append(", {");
            boolean bl3 = true;
            for (Map.Entry<TagAttr, Object> entry : this.attributes.entrySet()) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                JsonML.escapeStringOnto(entry.getKey().toString(), stringBuilder);
                stringBuilder.append("\": ");
                Object object = entry.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                    continue;
                }
                if (object instanceof String) {
                    stringBuilder.append('\"');
                    JsonML.escapeStringOnto((String)object, stringBuilder);
                    stringBuilder.append('\"');
                    continue;
                }
                stringBuilder.append(object);
            }
            stringBuilder.append("}");
        }
        if (bl2) {
            for (JsonML jsonML : this.children) {
                stringBuilder.append(", ");
                stringBuilder.append(jsonML.toString());
            }
        }
        stringBuilder.append(']');
    }

    private static void escapeStringOnto(String string, StringBuilder stringBuilder) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': 
                case '\u2028': 
                case '\u2029': {
                    String string2 = Integer.toString(c, 16);
                    stringBuilder.append(string, n, i).append("\\u").append("0000", string2.length(), 4).append(string2);
                    n = i + 1;
                }
            }
        }
        stringBuilder.append(string, n, n2);
    }

    public String toStringTree() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            JsonML.toStringTreeHelper(this, 0, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Should not happen\n" + iOException);
        }
    }

    private static void toStringTreeHelper(JsonML jsonML, int n, StringBuilder stringBuilder) throws IOException {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("    ");
        }
        jsonML.toString(stringBuilder, true, false);
        stringBuilder.append("\n");
        for (JsonML jsonML2 : jsonML.getChildren()) {
            JsonML.toStringTreeHelper(jsonML2, n + 1, stringBuilder);
        }
    }
}

