/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.graph.DiGraph;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class FixedPointGraphTraversal<N, E> {
    private final EdgeCallback<N, E> callback;
    public static final String NON_HALTING_ERROR_MSG = "Fixed point computation not halting";

    public FixedPointGraphTraversal(EdgeCallback<N, E> edgeCallback) {
        this.callback = edgeCallback;
    }

    public static <NODE, EDGE> FixedPointGraphTraversal<NODE, EDGE> newTraversal(EdgeCallback<NODE, EDGE> edgeCallback) {
        return new FixedPointGraphTraversal<NODE, EDGE>(edgeCallback);
    }

    public void computeFixedPoint(DiGraph<N, E> diGraph) {
        HashSet hashSet = Sets.newHashSet();
        for (DiGraph.DiGraphNode<N, E> diGraphNode : diGraph.getDirectedGraphNodes()) {
            hashSet.add(diGraphNode.getValue());
        }
        this.computeFixedPoint(diGraph, hashSet);
    }

    public void computeFixedPoint(DiGraph<N, E> diGraph, N n) {
        HashSet hashSet = Sets.newHashSet();
        hashSet.add(n);
        this.computeFixedPoint(diGraph, hashSet);
    }

    public void computeFixedPoint(DiGraph<N, E> diGraph, Set<N> set) {
        int n = 0;
        long l = diGraph.getNodes().size();
        long l2 = Math.max(l * l * l, 100L);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (N n2 : set) {
            linkedHashSet.add(diGraph.getDirectedGraphNode(n2));
        }
        while (!linkedHashSet.isEmpty() && (long)n < l2) {
            N n2;
            DiGraph.DiGraphNode diGraphNode = (DiGraph.DiGraphNode)linkedHashSet.iterator().next();
            n2 = diGraphNode.getValue();
            linkedHashSet.remove(diGraphNode);
            List list = diGraphNode.getOutEdges();
            for (DiGraph.DiGraphEdge diGraphEdge : list) {
                Object n3 = diGraphEdge.getDestination().getValue();
                if (!this.callback.traverseEdge(n2, diGraphEdge.getValue(), n3)) continue;
                linkedHashSet.add(diGraphEdge.getDestination());
            }
            ++n;
        }
        Preconditions.checkState(((long)n != l2 ? 1 : 0) != 0, (Object)NON_HALTING_ERROR_MSG);
    }

    public static interface EdgeCallback<Node, Edge> {
        public boolean traverseEdge(Node var1, Edge var2, Node var3);
    }
}

